/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.javax.activation.internal;

import com.sun.activation.registries.MailcapFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiMailcapCommandMap
extends CommandMap {
    private static final Logger log = LoggerFactory.getLogger(OsgiMailcapCommandMap.class);
    private final Map<Bundle, MailcapFile> db = new HashMap<Bundle, MailcapFile>();
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMailcapEntries(InputStream mailcapFile, Bundle originatingBundle) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            this.db.put(originatingBundle, new MailcapFile(mailcapFile));
        }
        log.debug("Added mailcap entries from bundle {}", (Object)originatingBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMailcapEntriesForBundle(Bundle bundle) {
        boolean removed;
        Object object = this.sync;
        synchronized (object) {
            removed = this.db.remove(bundle) != null;
        }
        if (removed) {
            log.debug("Removed mailcap entries from bundle {}", (Object)bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandInfo[] getPreferredCommands(String mimeType) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        Object object = this.sync;
        synchronized (object) {
            this.getPreferredCommands(mimeType, commands, false);
            this.getPreferredCommands(mimeType, commands, true);
        }
        return commands.toArray(new CommandInfo[commands.size()]);
    }

    private void getPreferredCommands(String mimeType, List<CommandInfo> accumulator, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            Map commandMap;
            Map map = commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null) continue;
            for (Object verbObject : commandMap.keySet()) {
                String verb = (String)verbObject;
                if (this.commandsHaveVerb(accumulator, verb)) continue;
                List commands = (List)commandMap.get(verb);
                String className = (String)commands.get(0);
                accumulator.add(new CommandInfo(verb, className));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandInfo[] getAllCommands(String mimeType) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        Object object = this.sync;
        synchronized (object) {
            this.getAllCommands(mimeType, commands, false);
            this.getAllCommands(mimeType, commands, true);
        }
        return commands.toArray(new CommandInfo[commands.size()]);
    }

    private void getAllCommands(String mimeType, List<CommandInfo> accumulator, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            Map commandMap;
            Map map = commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null) continue;
            for (Object verbAsObject : commandMap.keySet()) {
                String verb = (String)verbAsObject;
                List commands = (List)commandMap.get(verb);
                for (Object command : commands) {
                    accumulator.add(new CommandInfo(verb, (String)command));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandInfo getCommand(String mimeType, String cmdName) {
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        CommandInfo command = null;
        Object object = this.sync;
        synchronized (object) {
            command = this.getCommand(mimeType, cmdName, false);
            if (command != null) {
                return command;
            }
            command = this.getCommand(mimeType, cmdName, true);
        }
        return command;
    }

    private CommandInfo getCommand(String mimeType, String commandName, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            String cmdClassName;
            List commands;
            Map commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null || (commands = (List)commandMap.get(commandName)) == null || (cmdClassName = (String)commands.get(0)) == null) continue;
            return new CommandInfo(commandName, cmdClassName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataContentHandler createDataContentHandler(String mimeType) {
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        Object object = this.sync;
        synchronized (object) {
            DataContentHandler dch = this.findDataContentHandler(mimeType, false);
            if (dch != null) {
                return dch;
            }
            return this.findDataContentHandler(mimeType, true);
        }
    }

    private DataContentHandler findDataContentHandler(String mimeType, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            String name;
            DataContentHandler dch;
            List v;
            Map commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null || (v = (List)commandMap.get("content-handler")) == null || (dch = this.getDataContentHandler(name = (String)v.get(0), entry.getKey())) == null) continue;
            return dch;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMimeTypes() {
        ArrayList<String> mimeTypesList = new ArrayList<String>();
        Object object = this.sync;
        synchronized (object) {
            for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
                String[] mimeTypes;
                for (String mimeType : mimeTypes = entry.getValue().getMimeTypes()) {
                    if (mimeTypesList.contains(mimeType)) continue;
                    mimeTypesList.add(mimeType);
                }
            }
        }
        return mimeTypesList.toArray(new String[mimeTypesList.size()]);
    }

    private DataContentHandler getDataContentHandler(String name, Bundle bundle) {
        try {
            return (DataContentHandler)bundle.loadClass(name).newInstance();
        }
        catch (InstantiationException e) {
            log.warn("Unable to instantiate " + DataContentHandler.class.getSimpleName() + " class ' " + name + " ' from bundle " + bundle, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to instantiate " + DataContentHandler.class.getSimpleName() + " class ' " + name + " ' from bundle " + bundle, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.warn("Unable to instantiate " + DataContentHandler.class.getSimpleName() + " class ' " + name + " ' from bundle " + bundle, (Throwable)e);
        }
        return null;
    }

    private boolean commandsHaveVerb(List<CommandInfo> commands, String verb) {
        for (CommandInfo commandInfo : commands) {
            if (!commandInfo.getCommandName().equals(verb)) continue;
            return true;
        }
        return false;
    }
}

