/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.valuemap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.fsprovider.internal.mapper.valuemap.ObjectConverter;
import org.jetbrains.annotations.NotNull;

public final class ValueMapDecorator
implements ValueMap {
    private final Map<String, Object> base;

    public ValueMapDecorator(Map<String, Object> base) {
        this.base = base;
    }

    public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        if (this.base instanceof ValueMap) {
            return (T)((ValueMap)this.base).get(name, type);
        }
        return ObjectConverter.convert(this.get(name), type);
    }

    @NotNull
    public <T> T get(@NotNull String name, @NotNull T defaultValue) {
        if (this.base instanceof ValueMap) {
            return (T)((ValueMap)this.base).get(name, defaultValue);
        }
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    public int size() {
        return this.base.size();
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.base.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    public Object get(Object key) {
        return this.base.get(key);
    }

    public Object put(String key, Object value) {
        return this.base.put(key, value);
    }

    public Object remove(Object key) {
        return this.base.remove(key);
    }

    public void putAll(Map<? extends String, ?> t) {
        this.base.putAll(t);
    }

    public void clear() {
        this.base.clear();
    }

    public Set<String> keySet() {
        return this.base.keySet();
    }

    public Collection<Object> values() {
        return this.base.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.base.entrySet();
    }

    public String toString() {
        return super.toString() + " : " + this.base.toString();
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object obj) {
        return this.base.equals(obj);
    }
}

