/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FileMonitor;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.FsMode;
import org.apache.sling.fsprovider.internal.FsResourceMapper;
import org.apache.sling.fsprovider.internal.InitialContentImportOptions;
import org.apache.sling.fsprovider.internal.mapper.ContentFileResourceMapper;
import org.apache.sling.fsprovider.internal.mapper.FileResourceMapper;
import org.apache.sling.fsprovider.internal.mapper.FileVaultResourceMapper;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;
import org.apache.sling.fsprovider.internal.parser.ContentFileTypes;
import org.apache.sling.fsprovider.internal.parser.ContentType;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(name="org.apache.sling.fsprovider.internal.FsResourceProvider", service={ResourceProvider.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Sling File System Resource Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class, factory=true)
public final class FsResourceProvider
extends ResourceProvider<Object> {
    public static final String RESOURCE_METADATA_FILE_DIRECTORY = ":org.apache.sling.fsprovider.file.directory";
    private String providerRoot;
    private File providerFile;
    private FileMonitor monitor;
    private FsMode fsMode;
    private FsResourceMapper fileMapper;
    private FsResourceMapper contentFileMapper;
    private FileVaultResourceMapper fileVaultMapper;
    private boolean overlayParentResourceProvider;
    private ContentFileCache contentFileCache;
    private FileStatCache fileStatCache;

    public Resource getResource(@NotNull ResolveContext<Object> ctx, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        boolean askParentResourceProvider;
        ResourceResolver resolver = ctx.getResourceResolver();
        Resource rsrc = null;
        if (this.fsMode == FsMode.FILEVAULT_XML) {
            if (this.fileVaultMapper.pathMatches(path)) {
                askParentResourceProvider = false;
                rsrc = this.fileVaultMapper.getResource(resolver, path);
            } else {
                askParentResourceProvider = true;
            }
        } else {
            askParentResourceProvider = this.overlayParentResourceProvider;
            rsrc = this.fileMapper.getResource(resolver, path);
            if (rsrc == null) {
                rsrc = this.contentFileMapper.getResource(resolver, path);
            }
        }
        if (askParentResourceProvider && (rsrc == null || rsrc.getResourceMetadata().containsKey((Object)RESOURCE_METADATA_FILE_DIRECTORY))) {
            Resource resourceFromParentResourceProvider;
            ResourceProvider rp = ctx.getParentResourceProvider();
            ResolveContext resolveContext = ctx.getParentResolveContext();
            if (rp != null && resolveContext != null && (resourceFromParentResourceProvider = rp.getResource(resolveContext, path, resourceContext, parent)) != null) {
                rsrc = resourceFromParentResourceProvider;
            }
        }
        return rsrc;
    }

    public Iterator<Resource> listChildren(@NotNull ResolveContext<Object> ctx, @NotNull Resource parent) {
        Iterator<Resource> children;
        boolean askParentResourceProvider;
        ResourceResolver resolver = ctx.getResourceResolver();
        ArrayList<Iterator> allChildren = new ArrayList<Iterator>();
        if (this.fsMode == FsMode.FILEVAULT_XML) {
            askParentResourceProvider = true;
            children = this.fileVaultMapper.getChildren(resolver, parent);
            if (children != null) {
                allChildren.add(children);
            }
        } else {
            askParentResourceProvider = this.overlayParentResourceProvider;
            children = this.contentFileMapper.getChildren(resolver, parent);
            if (children != null) {
                allChildren.add(children);
            }
            if ((children = this.fileMapper.getChildren(resolver, parent)) != null) {
                allChildren.add(children);
            }
        }
        if (askParentResourceProvider) {
            ResourceProvider parentResourceProvider = ctx.getParentResourceProvider();
            ResolveContext resolveContext = ctx.getParentResolveContext();
            if (parentResourceProvider != null && resolveContext != null && (children = parentResourceProvider.listChildren(resolveContext, parent)) != null) {
                if (this.fsMode == FsMode.FILEVAULT_XML) {
                    allChildren.add(IteratorUtils.filteredIterator((Iterator)children, (Predicate)new Predicate(){

                        public boolean evaluate(Object object) {
                            Resource child = (Resource)object;
                            return !FsResourceProvider.this.fileVaultMapper.pathMatches(child.getPath());
                        }
                    }));
                } else {
                    allChildren.add(children);
                }
            }
        }
        if (allChildren.isEmpty()) {
            return null;
        }
        if (allChildren.size() == 1) {
            return (Iterator)allChildren.get(0);
        }
        return IteratorUtils.filteredIterator((Iterator)IteratorUtils.chainedIterator(allChildren), (Predicate)new Predicate(){
            private Set<String> names = new HashSet<String>();

            public boolean evaluate(Object object) {
                Resource resource = (Resource)object;
                return this.names.add(resource.getName());
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.fsMode = config.provider_fs_mode();
        String providerRoot = config.provider_root();
        if (StringUtils.isBlank((CharSequence)providerRoot)) {
            throw new IllegalArgumentException("provider.root property must be set");
        }
        String providerFileName = config.provider_file();
        if (StringUtils.isBlank((CharSequence)providerFileName)) {
            throw new IllegalArgumentException("provider.file property must be set");
        }
        this.providerRoot = providerRoot;
        this.providerFile = this.getProviderFile(providerFileName, bundleContext);
        this.overlayParentResourceProvider = false;
        InitialContentImportOptions options = new InitialContentImportOptions(config.provider_initial_content_import_options());
        File filterXmlFile = null;
        ArrayList<String> contentFileSuffixes = new ArrayList<String>();
        if (this.fsMode == FsMode.FILEVAULT_XML) {
            contentFileSuffixes.add("/.content.xml");
            contentFileSuffixes.add(ContentFileTypes.XML_SUFFIX);
            if (StringUtils.isNotBlank((CharSequence)config.provider_filevault_filterxml_path())) {
                filterXmlFile = new File(config.provider_filevault_filterxml_path());
            }
        } else if (this.fsMode == FsMode.FILES_FOLDERS) {
            this.overlayParentResourceProvider = true;
        } else if (this.fsMode == FsMode.INITIAL_CONTENT) {
            boolean bl = this.overlayParentResourceProvider = !options.isOverwrite();
            if (!options.getIgnoreImportProviders().contains(ContentType.JSON.getExtension())) {
                contentFileSuffixes.add(ContentFileTypes.JSON_SUFFIX);
            }
            if (!options.getIgnoreImportProviders().contains(ContentType.JCR_XML.getExtension())) {
                contentFileSuffixes.add(ContentFileTypes.JCR_XML_SUFFIX);
            }
            if (!options.getIgnoreImportProviders().contains(ContentType.XML.getExtension())) {
                contentFileSuffixes.add(ContentFileTypes.XML_SUFFIX);
            }
        }
        ContentFileExtensions contentFileExtensions = new ContentFileExtensions(contentFileSuffixes);
        this.contentFileCache = new ContentFileCache(config.provider_cache_size());
        this.fileStatCache = new FileStatCache(this.providerFile);
        if (this.fsMode == FsMode.FILEVAULT_XML) {
            this.fileVaultMapper = new FileVaultResourceMapper(this.providerFile, filterXmlFile, this.contentFileCache, this.fileStatCache);
        } else {
            this.fileMapper = new FileResourceMapper(this.providerRoot, this.providerFile, contentFileExtensions, this.contentFileCache, this.fileStatCache);
            this.contentFileMapper = new ContentFileResourceMapper(this.providerRoot, this.providerFile, contentFileExtensions, this.contentFileCache, this.fileStatCache);
        }
        if (config.provider_checkinterval() > 100L) {
            this.monitor = new FileMonitor(this, config.provider_checkinterval(), this.fsMode, contentFileExtensions, this.contentFileCache, this.fileStatCache);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
        this.providerRoot = null;
        this.providerFile = null;
        this.overlayParentResourceProvider = false;
        this.fileMapper = null;
        this.contentFileMapper = null;
        this.fileVaultMapper = null;
        if (this.contentFileCache != null) {
            this.contentFileCache.clear();
            this.contentFileCache = null;
        }
        this.fsMode = null;
    }

    File getRootFile() {
        return this.providerFile;
    }

    String getProviderRoot() {
        return this.providerRoot;
    }

    private File getProviderFile(String providerFileName, BundleContext bundleContext) {
        String home;
        File providerFile = new File(providerFileName);
        if (!providerFile.isAbsolute() && (home = bundleContext.getProperty("sling.home")) != null && home.length() > 0) {
            providerFile = new File(home, providerFileName);
        }
        if (!(providerFile = providerFile.getAbsoluteFile()).exists() && !providerFile.mkdirs()) {
            throw new IllegalArgumentException("Cannot create provider file root " + providerFile);
        }
        return providerFile;
    }

    public ObservationReporter getObservationReporter() {
        ProviderContext ctx = this.getProviderContext();
        if (ctx != null) {
            return ctx.getObservationReporter();
        }
        return null;
    }

    @ObjectClassDefinition(name="Apache Sling File System Resource Provider", description="Configure an instance of the file system resource provider in terms of provider root and file system location")
    public static @interface Config {
        @AttributeDefinition(name="File System Root", description="File system directory mapped to the virtual resource tree. This property must not be an empty string. If the path is relative it is resolved against sling.home or the current working directory. The path may be a file or folder. If the path does not address an existing file or folder, an empty folder is created.")
        public String provider_file();

        @AttributeDefinition(name="Provider Root", description="Location in the virtual resource tree where the file system resources are mapped in. This property must not be an empty string.")
        public String provider_root();

        @AttributeDefinition(name="File system layout", description="File system layout mode for files, folders and content.", options={@Option(value="FILES_FOLDERS", label="FILES_FOLDERS - Support only files and folders (classic mode)"), @Option(value="INITIAL_CONTENT", label="INITIAL_CONTENT - Sling-Initial-Content file system layout, supports file and folders ant content files in JSON, xml and jcr.xml format"), @Option(value="FILEVAULT_XML", label="FILEVAULT_XML - FileVault XML format (expanded content package)")})
        public FsMode provider_fs_mode() default FsMode.FILES_FOLDERS;

        @AttributeDefinition(name="Init. Content Options", description="Import options for Sling-Initial-Content file system layout. Supported options: overwrite, ignoreImportProviders.")
        public String provider_initial_content_import_options();

        @AttributeDefinition(name="FileVault Filter", description="Path to META-INF/vault/filter.xml when using FileVault XML file system layout.")
        public String provider_filevault_filterxml_path();

        @AttributeDefinition(name="Check Interval", description="If the interval has a value higher than 100, the provider will check the file system for changes periodically. This interval defines the period in milliseconds (the default is 1000). If a change is detected, resource events are sent through the event admin.")
        public long provider_checkinterval() default 1000L;

        @AttributeDefinition(name="Cache Size", description="Max. number of content files cached in memory.")
        public int provider_cache_size() default 10000;

        public String webconsole_configurationFactory_nameHint() default "{provider.fs.mode}: {provider.root}";
    }
}

