/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationManagementSettings.class})
@Designate(ocd=Config.class)
public class ConfigurationManagementSettingsImpl
implements ConfigurationManagementSettings {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManagementSettingsImpl.class);
    private Pattern[] ignorePropertyNameRegex;

    @Activate
    private void activate(Config config) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String patternString : config.ignorePropertyNameRegex()) {
            try {
                patterns.add(Pattern.compile(patternString));
            }
            catch (PatternSyntaxException ex) {
                log.warn("Ignoring invalid regex pattern: " + patternString, (Throwable)ex);
            }
        }
        this.ignorePropertyNameRegex = patterns.toArray(new Pattern[patterns.size()]);
    }

    @Override
    public Set<String> getIgnoredPropertyNames(Set<String> propertyNames) {
        HashSet<String> ignoredPropertyNames = new HashSet<String>();
        block0: for (String propertyName : propertyNames) {
            for (Pattern ignorePattern : this.ignorePropertyNameRegex) {
                if (!ignorePattern.matcher(propertyName).matches()) continue;
                ignoredPropertyNames.add(propertyName);
                continue block0;
            }
        }
        return ignoredPropertyNames;
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Management Settings", description="Management settings for reading and writing configurations.")
    static @interface Config {
        @AttributeDefinition(name="Ignore Property Regex", description="List of regular expressions with property names that should be ignored when reading or writing configuration data properties.")
        public String[] ignorePropertyNameRegex() default {"^jcr:.+$"};
    }
}

