/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridAdjustment;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.netcdf.ucar.GridWrapper;
import org.apache.sis.internal.netcdf.ucar.Utils;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.opengis.referencing.operation.Matrix;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;

final class VariableWrapper
extends Variable {
    private final ucar.nc2.Variable variable;
    private final ucar.nc2.Variable raw;

    VariableWrapper(Decoder decoder, ucar.nc2.Variable variable) {
        super(decoder);
        this.variable = variable;
        if (variable instanceof VariableEnhanced && (variable = ((VariableEnhanced)variable).getOriginalVariable()) == null) {
            variable = this.variable;
        }
        this.raw = variable;
        ImmutableMap immutableMap = null;
        if (this.variable.getDataType().isEnum()) {
            immutableMap = this.variable.getEnumTypedef().getMap();
        }
        this.setEnumeration((Map<Integer, String>)immutableMap);
    }

    @Override
    public String getFilename() {
        String string = Utils.nonEmpty(this.variable.getDatasetLocation());
        if (string != null) {
            return string.substring(Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar)) + 1);
        }
        return super.getFilename();
    }

    @Override
    public String getGroupName() {
        Group group = this.variable.getParentGroup();
        return group != null ? group.getShortName() : null;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return Utils.nonEmpty(this.variable.getDescription());
    }

    @Override
    protected String getUnitsString() {
        return Strings.trimOrNull((String)this.variable.getUnitsString());
    }

    @Override
    protected Unit<?> parseUnit(String string) throws Exception {
        if (TIME_UNIT_PATTERN.matcher(string).matches()) {
            DateUnit dateUnit = new DateUnit(string);
            this.epoch = dateUnit.getDateOrigin().toInstant();
            return Units.SECOND.multiply(dateUnit.getTimeUnit().getValueInSeconds());
        }
        SimpleUnit simpleUnit = SimpleUnit.factoryWithExceptions((String)string);
        if (simpleUnit.isUnknownUnit()) {
            return Units.valueOf((String)string);
        }
        String string2 = simpleUnit.getUnitString();
        Unit unit = Units.valueOf((String)string2);
        double d = simpleUnit.getValue();
        double d2 = simpleUnit.convertTo(0.0, SimpleUnit.factoryWithExceptions((String)string2));
        unit = unit.shift(d2);
        if (!Double.isNaN(d)) {
            unit = unit.multiply(d);
        }
        return unit;
    }

    @Override
    public DataType getDataType() {
        switch (this.variable.getDataType()) {
            case STRING: {
                return DataType.STRING;
            }
            case CHAR: {
                return DataType.CHAR;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case UBYTE: {
                return DataType.UBYTE;
            }
            case SHORT: {
                return DataType.SHORT;
            }
            case USHORT: {
                return DataType.USHORT;
            }
            case INT: {
                return DataType.INT;
            }
            case UINT: {
                return DataType.UINT;
            }
            case LONG: {
                return DataType.INT64;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
        }
        return DataType.UNKNOWN;
    }

    @Override
    protected boolean isUnlimited() {
        return this.variable.isUnlimited();
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.variable.isCoordinateVariable() || this.variable instanceof CoordinateAxis;
    }

    @Override
    protected String getAxisType() {
        AxisType axisType;
        if (this.variable instanceof CoordinateAxis && (axisType = ((CoordinateAxis)this.variable).getAxisType()) != null) {
            return axisType.name();
        }
        return this.getAttributeAsString("_CoordinateAxisType");
    }

    @Override
    protected Grid getGrid(GridAdjustment gridAdjustment) throws IOException, DataStoreException {
        ImmutableList immutableList;
        if (this.variable instanceof VariableDS && !(immutableList = ((VariableDS)this.variable).getCoordinateSystems()).isEmpty()) {
            GridWrapper gridWrapper = null;
            String[] stringArray = this.decoder.convention().namesOfAxisVariables(this);
            for (Grid grid : this.decoder.getGrids()) {
                GridWrapper gridWrapper2 = ((GridWrapper)grid).forVariable(this.variable, (List<CoordinateSystem>)immutableList, stringArray);
                if (gridWrapper2 == null || gridWrapper != null && gridWrapper2.getSourceDimensions() <= gridWrapper.getSourceDimensions()) continue;
                gridWrapper = gridWrapper2;
            }
            if (gridWrapper != null) {
                return gridWrapper;
            }
        }
        return (GridWrapper)super.getGrid(gridAdjustment);
    }

    @Override
    public int getNumDimensions() {
        return this.variable.getRank();
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return DimensionWrapper.wrap((Collection<ucar.nc2.Dimension>)this.variable.getDimensions());
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames((Iterable<Attribute>)this.variable.attributes());
    }

    @Override
    public Class<?> getAttributeType(String string) {
        return VariableWrapper.getAttributeType(this.raw.attributes().findAttributeIgnoreCase(string));
    }

    static Class<?> getAttributeType(Attribute attribute) {
        if (attribute != null) {
            if (attribute.isArray()) {
                return Vector.class;
            }
            switch (attribute.getDataType()) {
                case BYTE: {
                    return Byte.class;
                }
                case UBYTE: 
                case SHORT: {
                    return Short.class;
                }
                case USHORT: 
                case INT: {
                    return Integer.class;
                }
                case UINT: 
                case LONG: {
                    return Long.class;
                }
                case FLOAT: {
                    return Float.class;
                }
                case DOUBLE: {
                    return Double.class;
                }
                case STRING: {
                    return String.class;
                }
            }
            return Object.class;
        }
        return null;
    }

    @Override
    protected Object getAttributeValue(String string) {
        return VariableWrapper.getAttributeValue(this.raw.attributes().findAttributeIgnoreCase(string));
    }

    static Object getAttributeValue(Attribute attribute) {
        if (attribute != null) {
            int n = attribute.getLength();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    Object object = attribute.getValue(0);
                    if (object instanceof String) {
                        return Utils.nonEmpty((String)object);
                    }
                    if (!(object instanceof Number)) break;
                    return Utils.fixSign((Number)object, attribute.getDataType().isUnsigned());
                }
                default: {
                    if (attribute.isString()) {
                        boolean bl = false;
                        String[] stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = Utils.nonEmpty(attribute.getStringValue(i));
                            bl |= stringArray[i] != null;
                        }
                        if (!bl) break;
                        return stringArray;
                    }
                    Array array = attribute.getValues();
                    return VariableWrapper.createDecimalVector(array.get1DJavaArray(ucar.ma2.DataType.getType((Array)array)), attribute.getDataType().isUnsigned());
                }
            }
        }
        return null;
    }

    static List<String> toNames(Iterable<Attribute> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Attribute attribute : iterable) {
            arrayList.add(attribute.getShortName());
        }
        return arrayList;
    }

    @Override
    protected NumberRange<?> getRangeFallback() {
        EnhanceScaleMissingUnsigned enhanceScaleMissingUnsigned;
        if (this.variable instanceof EnhanceScaleMissingUnsigned && (enhanceScaleMissingUnsigned = (EnhanceScaleMissingUnsigned)this.variable).hasValidData()) {
            return MeasurementRange.create((double)enhanceScaleMissingUnsigned.getValidMin(), (boolean)true, (double)enhanceScaleMissingUnsigned.getValidMax(), (boolean)true, this.getUnit());
        }
        return super.getRangeFallback();
    }

    @Override
    protected boolean isExternallyCached() {
        return true;
    }

    @Override
    protected Object readFully() throws IOException {
        return this.get1DJavaArray(this.variable.read());
    }

    @Override
    public Vector read(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        Object object = this.readArray(gridExtent, nArray);
        return Vector.create((Object)object, (boolean)this.variable.getDataType().isUnsigned());
    }

    @Override
    public List<?> readAnyType(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        Object object = this.readArray(gridExtent, nArray);
        ucar.ma2.DataType dataType = this.variable.getDataType();
        if (dataType == ucar.ma2.DataType.CHAR && this.variable.getRank() >= 2) {
            return this.createStringList(object, gridExtent);
        }
        return Vector.create((Object)object, (boolean)dataType.isUnsigned());
    }

    private Object readArray(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        Array array;
        int n = gridExtent.getDimension();
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = nArray != null ? new int[n] : null;
        --n;
        for (int i = 0; i <= n; ++i) {
            int n2 = n - i;
            nArray2[n2] = Math.toIntExact(gridExtent.getLow(i));
            nArray3[n2] = Math.toIntExact(gridExtent.getSize(i));
            if (nArray4 == null) continue;
            nArray4[n2] = nArray[i];
        }
        try {
            array = this.variable.read(nArray4 != null ? new Section(nArray2, nArray3, nArray4) : new Section(nArray2, nArray3));
        }
        catch (InvalidRangeException invalidRangeException) {
            throw new DataStoreException((Throwable)invalidRangeException);
        }
        return this.get1DJavaArray(array);
    }

    private Object get1DJavaArray(Array array) {
        Object object = array.get1DJavaArray(ucar.ma2.DataType.getType((Array)array));
        this.replaceNaN(object);
        return object;
    }

    @Override
    protected String[] createStringArray(Object object, int n, int n2) {
        char[] cArray = (char[])object;
        String[] stringArray = new String[n];
        String string = "";
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6;
            String string2 = "";
            int n7 = n6 = n5 + n2;
            while (--n7 >= n5) {
                if (cArray[n7] <= ' ') continue;
                while (cArray[n5] <= ' ') {
                    ++n5;
                }
                if (JDK9.equals((char[])cArray, (int)n5, (int)(++n7), (char[])cArray, (int)n3, (int)n4)) {
                    string2 = string;
                    break;
                }
                string = string2 = new String(cArray, n5, n7 - n5);
                n3 = n5;
                n4 = n7;
                break;
            }
            stringArray[i] = string2;
            n5 = n6;
        }
        return stringArray;
    }

    @Override
    protected double coordinateForAxis(int n, int n2) {
        return this.variable instanceof CoordinateAxis2D ? ((CoordinateAxis2D)this.variable).getCoordValue(n, n2) : Double.NaN;
    }

    @Override
    protected boolean trySetTransform(Matrix matrix, int n, int n2, Vector vector) throws IOException, DataStoreException {
        CoordinateAxis1D coordinateAxis1D;
        if (this.variable instanceof CoordinateAxis1D && (coordinateAxis1D = (CoordinateAxis1D)this.variable).isRegular()) {
            double d = coordinateAxis1D.getStart();
            double d2 = coordinateAxis1D.getIncrement();
            if (d != 0.0 || d2 != 0.0) {
                matrix.setElement(n2, n, d2);
                matrix.setElement(n2, matrix.getNumCol() - 1, d);
                return true;
            }
        }
        return super.trySetTransform(matrix, n, n2, vector);
    }

    final boolean isWrapperFor(ucar.nc2.Variable variable) {
        return this.variable == variable || this.raw == variable;
    }
}

