/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.List;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.storage.DataStoreException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableIF;

final class VariableWrapper
extends Variable {
    private final VariableIF variable;
    private final List<? extends Dimension> all;

    VariableWrapper(VariableIF variable, List<? extends Dimension> all) {
        this.variable = variable;
        this.all = all;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return this.variable.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.variable.getUnitsString();
    }

    @Override
    public Class<?> getDataType() {
        return this.variable.getDataType().getPrimitiveClassType();
    }

    @Override
    public boolean isUnsigned() {
        return this.variable.isUnsigned();
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        String name = null;
        Attribute attribute = this.variable.findAttributeIgnoreCase("_CoordinateVariableAlias");
        if (attribute != null) {
            name = attribute.getStringValue();
        }
        if (name == null) {
            name = this.getName();
        }
        for (Dimension dimension : this.all) {
            if (!name.equals(dimension.getShortName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getGridDimensionNames() {
        List dimensions = this.variable.getDimensions();
        String[] names = new String[dimensions.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((Dimension)dimensions.get(i)).getShortName();
        }
        return names;
    }

    @Override
    public int[] getGridEnvelope() {
        return this.variable.getShape();
    }

    @Override
    public Object[] getAttributeValues(String attributeName, boolean numeric) {
        Attribute attribute = this.variable.findAttributeIgnoreCase(attributeName);
        if (attribute != null) {
            boolean hasValues = false;
            Object[] values = new Object[attribute.getLength()];
            for (int i = 0; i < values.length; ++i) {
                String text;
                if (numeric) {
                    values[i] = attribute.getNumericValue(i);
                    if (values[i] == null) continue;
                    hasValues = true;
                    continue;
                }
                Object value = attribute.getValue(i);
                if (value == null || (text = value.toString().trim()).isEmpty()) continue;
                values[i] = text;
                hasValues = true;
            }
            if (hasValues) {
                return values;
            }
        }
        return new Object[0];
    }

    @Override
    public Object read() throws IOException {
        Array array = this.variable.read();
        return array.get1DJavaArray(array.getElementType());
    }

    @Override
    public Object read(int[] areaLower, int[] areaUpper, int[] subsampling) throws IOException, DataStoreException {
        Array array;
        int[] size = new int[areaUpper.length];
        for (int i = 0; i < size.length; ++i) {
            size[i] = areaUpper[i] - areaLower[i];
        }
        try {
            array = this.variable.read(new Section(areaLower, size, subsampling));
        }
        catch (InvalidRangeException e) {
            throw new DataStoreException((Throwable)e);
        }
        return array.get1DJavaArray(array.getElementType());
    }
}

