/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.IOException;
import java.util.List;
import org.apache.sis.internal.netcdf.Variable;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableIF;

final class VariableWrapper
extends Variable {
    private final VariableIF variable;
    private final List<? extends Dimension> all;

    VariableWrapper(VariableIF variableIF, List<? extends Dimension> list) {
        this.variable = variableIF;
        this.all = list;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return this.variable.getDescription();
    }

    @Override
    public Class<?> getDataType() {
        return this.variable.getDataType().getPrimitiveClassType();
    }

    @Override
    public boolean isUnsigned() {
        return this.variable.isUnsigned();
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        String string = null;
        Attribute attribute = this.variable.findAttributeIgnoreCase("_CoordinateVariableAlias");
        if (attribute != null) {
            string = attribute.getStringValue();
        }
        if (string == null) {
            string = this.getName();
        }
        for (Dimension dimension : this.all) {
            if (!string.equals(dimension.getShortName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getGridDimensionNames() {
        List list = this.variable.getDimensions();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Dimension)list.get(i)).getShortName();
        }
        return stringArray;
    }

    @Override
    public int[] getGridEnvelope() {
        return this.variable.getShape();
    }

    @Override
    public Object[] getAttributeValues(String string, boolean bl) {
        Attribute attribute = this.variable.findAttributeIgnoreCase(string);
        if (attribute != null) {
            boolean bl2 = false;
            Object[] objectArray = new Object[attribute.getLength()];
            for (int i = 0; i < objectArray.length; ++i) {
                String string2;
                if (bl) {
                    objectArray[i] = attribute.getNumericValue(i);
                    if (objectArray[i] == null) continue;
                    bl2 = true;
                    continue;
                }
                Object object = attribute.getValue(i);
                if (object == null || (string2 = object.toString().trim()).isEmpty()) continue;
                objectArray[i] = string2;
                bl2 = true;
            }
            if (bl2) {
                return objectArray;
            }
        }
        return new Object[0];
    }

    @Override
    public Object read() throws IOException {
        Array array = this.variable.read();
        return array.get1DJavaArray(array.getElementType());
    }
}

