/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.Classes;

public abstract class Variable {
    public static final int MIN_DIMENSION = 2;
    protected static final String _CoordinateVariableAlias = "_CoordinateVariableAlias";

    protected Variable() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract Class<?> getDataType();

    public final String getDataTypeName() {
        StringBuilder stringBuilder = new StringBuilder(20);
        if (this.isUnsigned()) {
            stringBuilder.append("unsigned ");
        }
        stringBuilder.append(Classes.getShortName(this.getDataType()));
        int[] nArray = this.getGridEnvelope();
        int n = nArray.length;
        while (--n >= 0) {
            stringBuilder.append('[').append((long)nArray[n] & 0xFFFFFFFFL).append(']');
        }
        return stringBuilder.toString();
    }

    public final int getRasterDataType() {
        Class<?> clazz = this.getDataType();
        if (clazz == Boolean.TYPE || clazz == Byte.TYPE) {
            return 0;
        }
        if (clazz == Short.TYPE) {
            return this.isUnsigned() ? 1 : 2;
        }
        if (clazz == Integer.TYPE) {
            return 3;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Double.TYPE) {
            return 5;
        }
        return 32;
    }

    public abstract boolean isUnsigned();

    public final boolean isCoverage(int n) {
        int n2 = 0;
        for (int n3 : this.getGridEnvelope()) {
            if (((long)n3 & 0xFFFFFFFFL) < (long)n) continue;
            ++n2;
        }
        if (n2 >= 2 && this.getRasterDataType() != 32) {
            return !this.isCoordinateSystemAxis();
        }
        return false;
    }

    public abstract boolean isCoordinateSystemAxis();

    public abstract String[] getGridDimensionNames();

    public abstract int[] getGridEnvelope();

    public abstract Object[] getAttributeValues(String var1, boolean var2);

    public abstract Object read() throws IOException, DataStoreException;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName()).append(" : ").append(Classes.getShortName(this.getDataType()));
        int[] nArray = this.getGridEnvelope();
        int n = nArray.length;
        while (--n >= 0) {
            stringBuilder.append('[').append((long)nArray[n] & 0xFFFFFFFFL).append(']');
        }
        return stringBuilder.toString();
    }
}

