/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Attribute;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.resources.Errors;

final class VariableInfo
extends Variable {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    static final int BYTE = 1;
    static final int CHAR = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int FLOAT = 5;
    static final int DOUBLE = 6;
    private static final int[] SIZES = new int[]{1, 1, 2, 4, 4, 8};
    private static final Class<?>[] TYPES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE};
    private final ChannelDataInput input;
    private final String name;
    final Dimension[] dimensions;
    private final Dimension[] allDimensions;
    private final Map<String, Attribute> attributes;
    private final int datatype;
    private final long offset;
    GridGeometryInfo gridGeometry;

    VariableInfo(ChannelDataInput input, String name, Dimension[] dimensions, Dimension[] allDimensions, Map<String, Attribute> attributes, int datatype, int size, long offset) {
        this.input = input;
        this.name = name;
        this.dimensions = dimensions;
        this.allDimensions = allDimensions;
        this.attributes = attributes;
        this.datatype = datatype;
        this.offset = offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String attributeName : DESCRIPTION_ATTRIBUTES) {
            Attribute attribute = this.attributes.get(attributeName);
            if (attribute == null || !(attribute.value instanceof String)) continue;
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public Class<?> getDataType() {
        int i = this.datatype - 1;
        return i >= 0 && i < TYPES.length ? TYPES[i] : null;
    }

    static int sizeOf(int datatype) {
        return --datatype >= 0 && datatype < SIZES.length ? SIZES[datatype] : 0;
    }

    @Override
    public boolean isUnsigned() {
        Attribute attribute = this.attributes.get("_Unsigned");
        return attribute != null && attribute.booleanValue();
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        String name = this.name;
        Attribute attribute = this.attributes.get("_CoordinateVariableAlias");
        if (attribute != null && attribute.value instanceof String) {
            name = (String)attribute.value;
        }
        for (Dimension dimension : this.allDimensions) {
            if (!name.equals(dimension.name)) continue;
            return true;
        }
        return false;
    }

    final String getAxisType() {
        Attribute attribute = this.attributes.get("_CoordinateAxisType");
        if (attribute != null && attribute.value instanceof String) {
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public String[] getGridDimensionNames() {
        String[] names = new String[this.dimensions.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.dimensions[i].name;
        }
        return names;
    }

    @Override
    public int[] getGridEnvelope() {
        int[] shape = new int[this.dimensions.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = this.dimensions[i].length;
        }
        return shape;
    }

    @Override
    public Object[] getAttributeValues(String attributeName, boolean numeric) {
        Attribute attribute = this.attributes.get(attributeName);
        if (attribute != null) {
            return numeric ? attribute.numberValues() : attribute.stringValues();
        }
        return new Object[0];
    }

    @Override
    public Object read() throws IOException, DataStoreException {
        long length = 1L;
        for (Dimension dimension : this.dimensions) {
            length *= (long)dimension.length;
        }
        if (length > Integer.MAX_VALUE) {
            throw new DataStoreException(Errors.format((int)94, (Object)this.name, (Object)length));
        }
        this.input.seek(this.offset);
        switch (this.datatype) {
            case 1: {
                return this.input.readBytes((int)length);
            }
            case 3: {
                return this.input.readShorts((int)length);
            }
            case 4: {
                return this.input.readInts((int)length);
            }
            case 5: {
                return this.input.readFloats((int)length);
            }
            case 6: {
                return this.input.readDoubles((int)length);
            }
        }
        throw new DataStoreException(Errors.format((int)76, (Object)this.datatype));
    }
}

