/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.Classes;

public abstract class Variable {
    public static final int MIN_DIMENSION = 2;
    protected static final String _CoordinateVariableAlias = "_CoordinateVariableAlias";

    protected Variable() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract Class<?> getDataType();

    public final String getDataTypeName() {
        StringBuilder buffer = new StringBuilder(20);
        if (this.isUnsigned()) {
            buffer.append("unsigned ");
        }
        buffer.append(Classes.getShortName(this.getDataType()));
        int[] shape = this.getGridEnvelope();
        int i = shape.length;
        while (--i >= 0) {
            buffer.append('[').append((long)shape[i] & 0xFFFFFFFFL).append(']');
        }
        return buffer.toString();
    }

    public final int getRasterDataType() {
        Class<?> type = this.getDataType();
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 0;
        }
        if (type == Short.TYPE) {
            return this.isUnsigned() ? 1 : 2;
        }
        if (type == Integer.TYPE) {
            return 3;
        }
        if (type == Float.TYPE) {
            return 4;
        }
        if (type == Double.TYPE) {
            return 5;
        }
        return 32;
    }

    public abstract boolean isUnsigned();

    public final boolean isCoverage(int minSpan) {
        int numVectors = 0;
        for (int length : this.getGridEnvelope()) {
            if (((long)length & 0xFFFFFFFFL) < (long)minSpan) continue;
            ++numVectors;
        }
        if (numVectors >= 2 && this.getRasterDataType() != 32) {
            return !this.isCoordinateSystemAxis();
        }
        return false;
    }

    public abstract boolean isCoordinateSystemAxis();

    public abstract String[] getGridDimensionNames();

    public abstract int[] getGridEnvelope();

    public abstract Object[] getAttributeValues(String var1, boolean var2);

    public abstract Object read() throws IOException, DataStoreException;

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getName()).append(" : ").append(Classes.getShortName(this.getDataType()));
        int[] shape = this.getGridEnvelope();
        int i = shape.length;
        while (--i >= 0) {
            buffer.append('[').append((long)shape[i] & 0xFFFFFFFFL).append(']');
        }
        return buffer.toString();
    }
}

