/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.cube.Cube;
import org.apache.sirona.cube.CubeBuilder;
import org.apache.sirona.store.tracking.BatchPathTrackingDataStore;
import org.apache.sirona.store.tracking.CollectorPathTrackingDataStore;
import org.apache.sirona.store.tracking.InMemoryPathTrackingDataStore;
import org.apache.sirona.tracking.PathTrackingEntry;
import org.apache.sirona.util.SerializeUtils;

public class CubePathTrackingDataStore
extends BatchPathTrackingDataStore
implements CollectorPathTrackingDataStore {
    private static final Cube CUBE = ((CubeBuilder)IoCs.findOrCreateInstance(CubeBuilder.class)).build();
    private static final boolean USE_EXECUTORS = Boolean.parseBoolean(Configuration.getProperty((String)"org.apache.sirona.pathtracking.post.useexecutors", (String)"false"));
    private static boolean USE_SINGLE_STORE = Boolean.parseBoolean(Configuration.getProperty((String)"org.apache.sirona.pathtracking.singlestore", (String)"false"));
    protected static ExecutorService executorService;

    public void store(PathTrackingEntry pathTrackingEntry) {
        CUBE.doPostBytes(SerializeUtils.serialize((Object)pathTrackingEntry), PathTrackingEntry.class.getName());
    }

    protected void pushEntriesByBatch(Map<String, List<InMemoryPathTrackingDataStore.Pointer>> pathTrackingEntries) {
        if (!USE_SINGLE_STORE) {
            for (Map.Entry<String, List<InMemoryPathTrackingDataStore.Pointer>> entry : pathTrackingEntries.entrySet()) {
                for (InMemoryPathTrackingDataStore.Pointer pointer : entry.getValue()) {
                    if (pointer.isFree()) continue;
                    CUBE.doPostBytes(this.readBytes(pointer), PathTrackingEntry.class.getName());
                    pointer.freeMemory();
                }
            }
        }
    }

    @Destroying
    public void destroy() {
        executorService.shutdownNow();
    }

    static {
        if (USE_EXECUTORS) {
            int threadsNumber = Configuration.getInteger((String)"org.apache.sirona.pathtracking.post.executors", (int)5);
            executorService = Executors.newFixedThreadPool(threadsNumber);
        }
    }
}

