/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.shiro.web.servlet.OncePerRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdviceFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdviceFilter.class);

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected void postHandle(ServletRequest request, ServletResponse response) throws Exception {
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
    }

    protected void executeChain(ServletRequest request, ServletResponse response, FilterChain chain) throws Exception {
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        Exception exception = null;
        try {
            boolean continueChain = this.preHandle(request, response);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Invoked preHandle method.  Continuing chain?: [" + continueChain + "]");
            }
            if (continueChain) {
                this.executeChain(request, response, chain);
            }
            this.postHandle(request, response);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Successfully invoked postHandle method");
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.cleanup(request, response, exception);
        }
    }

    protected void cleanup(ServletRequest request, ServletResponse response, Exception existing) throws ServletException, IOException {
        Exception exception = existing;
        try {
            this.afterCompletion(request, response, exception);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Successfully invoked afterCompletion method.");
            }
        }
        catch (Exception e) {
            if (exception == null) {
                exception = e;
            }
            LOGGER.debug("afterCompletion implementation threw an exception.  This will be ignored to allow the original source exception to be propagated.", (Throwable)e);
        }
        if (exception != null) {
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (LOGGER.isDebugEnabled()) {
                String msg = "Filter execution resulted in an unexpected Exception (not IOException or ServletException as the Filter API recommends).  Wrapping in ServletException and propagating.";
                LOGGER.debug(msg);
            }
            throw new ServletException((Throwable)exception);
        }
    }
}

