/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.cipher;

import java.io.IOException;
import org.apache.shiro.crypto.cipher.ByteSourceBroker;
import org.apache.shiro.crypto.cipher.ByteSourceUser;
import org.apache.shiro.crypto.cipher.JcaCipherService;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.util.ByteSourceWrapper;
import org.apache.shiro.util.ByteUtils;

public class SimpleByteSourceBroker
implements ByteSourceBroker,
Destroyable {
    private JcaCipherService cipherService;
    private byte[] ciphertext;
    private byte[] key;
    private boolean destroyed = false;

    public SimpleByteSourceBroker(JcaCipherService cipherService, byte[] ciphertext, byte[] key) {
        this.cipherService = cipherService;
        this.ciphertext = (byte[])ciphertext.clone();
        this.key = (byte[])key.clone();
    }

    @Override
    public synchronized void useBytes(ByteSourceUser user) {
        if (this.destroyed || user == null) {
            return;
        }
        ByteSource byteSource = this.cipherService.decryptInternal(this.ciphertext, this.key);
        try (ByteSourceWrapper temp = ByteSourceWrapper.wrap((Object)byteSource.getBytes());){
            user.use(temp.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public byte[] getClonedBytes() {
        ByteSource byteSource = this.cipherService.decryptInternal(this.ciphertext, this.key);
        return byteSource.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (!this.destroyed) {
            SimpleByteSourceBroker simpleByteSourceBroker = this;
            synchronized (simpleByteSourceBroker) {
                this.destroyed = true;
                this.cipherService = null;
                ByteUtils.wipe((Object)this.ciphertext);
                this.ciphertext = null;
                ByteUtils.wipe((Object)this.key);
                this.key = null;
            }
        }
    }
}

