/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import org.apache.commons.text.StringEscapeUtils;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.variables.Substitutions;

public class UserPrefSubstituter {
    public static void addSubstitutions(Substitutions substituter, GadgetSpec spec, UserPrefs values) {
        for (UserPref pref : spec.getUserPrefs()) {
            String name = pref.getName();
            String value = values.getPref(name);
            if (value == null && (value = pref.getDefaultValue()) == null) {
                value = "";
            }
            substituter.addSubstitution(Substitutions.Type.USER_PREF, name, StringEscapeUtils.escapeHtml4((String)value));
        }
    }
}

