/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Preload
implements RequestAuthenticationInfo {
    private static final Set<String> KNOWN_ATTRIBUTES = ImmutableSet.of((Object)"views", (Object)"href", (Object)"authz", (Object)"sign_owner", (Object)"sign_viewer");
    private final Uri base;
    private final Uri href;
    private final AuthType auth;
    private final boolean signOwner;
    private final boolean signViewer;
    private final Map<String, String> attributes;
    private final Set<String> views;

    public Preload(Element preload, Uri base) throws SpecParserException {
        this.base = base;
        this.href = XmlUtil.getUriAttribute((Node)preload, (String)"href");
        if (this.href == null) {
            throw new SpecParserException("Preload/@href is missing or invalid.");
        }
        String viewNames = XmlUtil.getAttribute((Node)preload, (String)"views", (String)"");
        HashSet views = Sets.newHashSet();
        for (String s : viewNames.split(",")) {
            if ((s = s.trim()).length() <= 0) continue;
            views.add(s.trim());
        }
        this.views = Collections.unmodifiableSet(views);
        this.auth = AuthType.parse(XmlUtil.getAttribute((Node)preload, (String)"authz"));
        this.signOwner = XmlUtil.getBoolAttribute((Node)preload, (String)"sign_owner", (boolean)true);
        this.signViewer = XmlUtil.getBoolAttribute((Node)preload, (String)"sign_viewer", (boolean)true);
        HashMap attributes = Maps.newHashMap();
        NamedNodeMap attrs = preload.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (KNOWN_ATTRIBUTES.contains(attr.getNodeName())) continue;
            attributes.put(attr.getNodeName(), attr.getNodeValue());
        }
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    private Preload(Preload preload, Substitutions substituter) {
        this.base = preload.base;
        this.views = preload.views;
        this.auth = preload.auth;
        this.signOwner = preload.signOwner;
        this.signViewer = preload.signViewer;
        this.href = this.base.resolve(substituter.substituteUri(preload.href));
        HashMap attributes = Maps.newHashMap();
        for (Map.Entry<String, String> entry : preload.attributes.entrySet()) {
            attributes.put(entry.getKey(), substituter.substituteString(entry.getValue()));
        }
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    @Override
    public Uri getHref() {
        return this.href;
    }

    @Override
    public AuthType getAuthType() {
        return this.auth;
    }

    @Override
    public boolean isSignOwner() {
        return this.signOwner;
    }

    @Override
    public boolean isSignViewer() {
        return this.signViewer;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<String> getViews() {
        return this.views;
    }

    public Preload substitute(Substitutions substituter) {
        return new Preload(this, substituter);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Preload href='").append(this.href).append('\'').append(" authz='").append(this.auth.toString().toLowerCase()).append('\'').append(" views='").append(StringUtils.join(this.views, (char)',')).append('\'');
        for (String attr : this.attributes.keySet()) {
            buf.append(' ').append(attr).append("='").append(this.attributes.get(attr)).append('\'');
        }
        buf.append("/>");
        return buf.toString();
    }
}

