/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Feature {
    private final String name;
    private final Map<String, String> params;
    private final boolean required;

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean getRequired() {
        return this.required;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.required ? "<Require" : "<Optional").append(" feature=\"").append(this.name).append("\">");
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            buf.append("\n<Param name=\"").append(entry.getKey()).append("\">").append(entry.getValue()).append("</Param>");
        }
        buf.append(this.required ? "</Require>" : "</Optional>");
        return buf.toString();
    }

    public Feature(Element feature) throws SpecParserException {
        this.required = feature.getNodeName().equals("Require");
        String name = XmlUtil.getAttribute((Node)feature, (String)"feature");
        if (name == null) {
            throw new SpecParserException((this.required ? "Require" : "Optional") + "@feature is required.");
        }
        this.name = name;
        NodeList children = feature.getElementsByTagName("Param");
        if (children.getLength() > 0) {
            ImmutableMap.Builder params = ImmutableMap.builder();
            int j = children.getLength();
            for (int i = 0; i < j; ++i) {
                Element param = (Element)children.item(i);
                String paramName = XmlUtil.getAttribute((Node)param, (String)"name");
                if (paramName == null) {
                    throw new SpecParserException("Param@name is required");
                }
                params.put((Object)paramName, (Object)param.getTextContent());
            }
            this.params = params.build();
        } else {
            this.params = Collections.emptyMap();
        }
    }
}

