/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.servlet.HttpUtil;

public abstract class ProxyBase {
    public static final String URL_PARAM = "url";
    public static final String REFRESH_PARAM = "refresh";
    public static final String IGNORE_CACHE_PARAM = "nocache";
    public static final String GADGET_PARAM = "gadget";
    public static final String CONTAINER_PARAM = "container";
    public static final String SYND_PARAM = "synd";
    public static final String REWRITE_MIME_TYPE_PARAM = "rewriteMime";

    protected Uri validateUrl(String urlToValidate) throws GadgetException {
        if (urlToValidate == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "url parameter is missing.");
        }
        try {
            UriBuilder url = UriBuilder.parse((String)urlToValidate);
            if (!"http".equals(url.getScheme()) && !"https".equals(url.getScheme())) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid request url scheme in url: " + Utf8UrlCoder.encode((String)urlToValidate) + "; only \"http\" and \"https\" supported.");
            }
            if (url.getPath() == null || url.getPath().length() == 0) {
                url.setPath("/");
            }
            return url.toUri();
        }
        catch (IllegalArgumentException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "url parameter is not a valid url.");
        }
    }

    protected String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String ret = request.getParameter(name);
        return ret == null ? defaultValue : ret;
    }

    protected String getContainer(HttpServletRequest request) {
        String container = this.getParameter(request, CONTAINER_PARAM, null);
        if (container == null) {
            container = this.getParameter(request, SYND_PARAM, "default");
        }
        return container;
    }

    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, HttpResponse results) {
        int refreshInterval = 0;
        refreshInterval = results.isStrictNoCache() ? 0 : (request.getParameter(REFRESH_PARAM) != null ? Integer.valueOf(request.getParameter(REFRESH_PARAM)) : Math.max(3600, (int)(results.getCacheTtl() / 1000L)));
        HttpUtil.setCachingHeaders(response, refreshInterval);
        if (!"application/x-shockwave-flash".equalsIgnoreCase(results.getHeader("Content-Type"))) {
            response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        }
    }

    public abstract void fetch(HttpServletRequest var1, HttpServletResponse var2) throws GadgetException, IOException;
}

