/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.oauth.OAuthCallbackState;
import org.apache.shindig.gadgets.servlet.HttpUtil;

public class OAuthCallbackServlet
extends InjectedServlet {
    public static final String CALLBACK_STATE_PARAM = "cs";
    public static final String REAL_DOMAIN_PARAM = "d";
    private static final int ONE_HOUR_IN_SECONDS = 3600;
    private static final String RESP_BODY = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>Close this window</title>\n</head>\n<body>\n<script type='text/javascript'>\n  if (window.opener && window.opener.gadgets && window.opener.gadgets.oauth\n      && window.opener.gadgets.oauth.Popup) {\n    window.opener.gadgets.oauth.Popup.setReceivedCallbackUrl(document.location.href);\n  }\n  window.close();\n</script>\nClose this window.\n</body>\n</html>\n";
    private BlobCrypter stateCrypter;

    @Inject
    public void setStateCrypter(@Named(value="shindig.oauth.state-crypter") BlobCrypter stateCrypter) {
        this.stateCrypter = stateCrypter;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OAuthCallbackState callbackState = new OAuthCallbackState(this.stateCrypter, req.getParameter(CALLBACK_STATE_PARAM));
        if (callbackState.getRealCallbackUrl() != null) {
            UriBuilder realUri = UriBuilder.parse((String)callbackState.getRealCallbackUrl());
            Map params = UriBuilder.splitParameters((String)req.getQueryString());
            for (String param : params.keySet()) {
                realUri.putQueryParameter(param, (Iterable)params.get(param));
            }
            realUri.removeQueryParameter(CALLBACK_STATE_PARAM);
            HttpUtil.setCachingHeaders(resp, 3600, true);
            resp.sendRedirect(realUri.toString());
            return;
        }
        HttpUtil.setCachingHeaders(resp, 3600, true);
        resp.setContentType("text/html; charset=UTF-8");
        resp.getWriter().write(RESP_BODY);
    }
}

