/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.JsonRpcGadgetContext;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcHandler {
    private final Processor processor;
    private final UrlGenerator urlGenerator;

    @Inject
    public JsonRpcHandler(Processor processor, UrlGenerator urlGenerator) {
        this.processor = processor;
        this.urlGenerator = urlGenerator;
    }

    public JSONObject process(JSONObject request) throws RpcException, JSONException {
        JSONObject requestContext = request.getJSONObject("context");
        JSONArray requestedGadgets = request.getJSONArray("gadgets");
        ArrayList gadgets = Lists.newArrayListWithExpectedSize((int)requestedGadgets.length());
        int j = requestedGadgets.length();
        for (int i = 0; i < j; ++i) {
            JSONObject jsonObject = requestedGadgets.getJSONObject(i);
            JsonRpcGadgetContext context = new JsonRpcGadgetContext(requestContext, jsonObject);
            gadgets.add(context);
        }
        JSONObject response = new JSONObject();
        for (GadgetContext context : gadgets) {
            try {
                JSONObject gadget = this.getGadgetJson(context);
                response.append("gadgets", (Object)gadget);
            }
            catch (JSONException e) {
                throw new RpcException("Unable to write JSON", (Throwable)e);
            }
        }
        return response;
    }

    public JSONObject getGadgetJson(GadgetContext context) throws RpcException {
        try {
            Gadget gadget = this.processor.process(context);
            GadgetSpec spec = gadget.getSpec();
            JSONObject gadgetJson = new JSONObject();
            ModulePrefs prefs = spec.getModulePrefs();
            JSONObject views = new JSONObject();
            for (View view : spec.getViews().values()) {
                views.put(view.getName(), (Object)new JSONObject().put("type", (Object)view.getType().toString().toLowerCase()).put("quirks", view.getQuirks()).put("preferredHeight", view.getPreferredHeight()).put("preferredWidth", view.getPreferredWidth()));
            }
            Set<String> feats = prefs.getFeatures().keySet();
            String[] features = feats.toArray(new String[feats.size()]);
            JSONObject links = new JSONObject();
            for (LinkSpec link : prefs.getLinks().values()) {
                links.put(link.getRel(), (Object)link.getHref());
            }
            JSONObject userPrefs = new JSONObject();
            for (UserPref pref : spec.getUserPrefs()) {
                JSONObject up = new JSONObject().put("displayName", (Object)pref.getDisplayName()).put("type", (Object)pref.getDataType().toString().toLowerCase()).put("default", (Object)pref.getDefaultValue()).put("enumValues", pref.getEnumValues()).put("orderedEnumValues", this.getOrderedEnums(pref));
                userPrefs.put(pref.getName(), (Object)up);
            }
            gadgetJson.put("iframeUrl", (Object)this.urlGenerator.getIframeUrl(gadget)).put("url", (Object)context.getUrl().toString()).put("moduleId", (Object)context.getModuleId()).put("title", (Object)prefs.getTitle()).put("titleUrl", (Object)prefs.getTitleUrl().toString()).put("views", (Object)views).put("features", (Object)features).put("userPrefs", (Object)userPrefs).put("links", (Object)links).put("directoryTitle", (Object)prefs.getDirectoryTitle()).put("thumbnail", (Object)prefs.getThumbnail().toString()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("author", (Object)prefs.getAuthor()).put("authorEmail", (Object)prefs.getAuthorEmail()).put("authorAffiliation", (Object)prefs.getAuthorAffiliation()).put("authorLocation", (Object)prefs.getAuthorLocation()).put("authorPhoto", (Object)prefs.getAuthorPhoto()).put("authorAboutme", (Object)prefs.getAuthorAboutme()).put("authorQuote", (Object)prefs.getAuthorQuote()).put("authorLink", (Object)prefs.getAuthorLink()).put("categories", prefs.getCategories()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("height", prefs.getHeight()).put("width", prefs.getWidth()).put("showStats", prefs.getShowStats()).put("showInDirectory", prefs.getShowInDirectory()).put("singleton", prefs.getSingleton()).put("scaling", prefs.getScaling()).put("scrolling", prefs.getScrolling());
            return gadgetJson;
        }
        catch (ProcessingException e) {
            JSONObject errorObj = new JSONObject();
            try {
                errorObj.put("url", (Object)context.getUrl()).put("moduleId", (Object)context.getModuleId());
                errorObj.append("errors", (Object)e.getLocalizedMessage());
            }
            catch (JSONException e1) {
                throw new RpcException(context, (Throwable)e1);
            }
            return errorObj;
        }
        catch (JSONException e) {
            throw new RpcException(context, (Throwable)e);
        }
    }

    private List<JSONObject> getOrderedEnums(UserPref pref) throws JSONException {
        List<UserPref.EnumValuePair> orderedEnums = pref.getOrderedEnumValues();
        ArrayList jsonEnums = Lists.newArrayListWithExpectedSize((int)orderedEnums.size());
        for (UserPref.EnumValuePair evp : orderedEnums) {
            JSONObject curEnum = new JSONObject();
            curEnum.put("value", (Object)evp.getValue());
            curEnum.put("displayValue", (Object)evp.getDisplayValue());
            jsonEnums.add(curEnum);
        }
        return jsonEnums;
    }
}

