/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetContext;
import org.json.JSONObject;

public class HttpUtil {
    public static final int DEFAULT_TTL = 31536000;
    private static TimeSource timeSource;

    public static void setTimeSource(TimeSource timeSource) {
        HttpUtil.timeSource = timeSource;
    }

    public static void setCachingHeaders(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, 31536000, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, boolean noProxy) {
        HttpUtil.setCachingHeaders(response, 31536000, noProxy);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl) {
        HttpUtil.setCachingHeaders(response, ttl, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl, boolean noProxy) {
        response.setDateHeader("Expires", timeSource.currentTimeMillis() + 1000L * (long)ttl);
        if (ttl == 0) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
        } else if (noProxy) {
            response.setHeader("Cache-Control", "private,max-age=" + Integer.toString(ttl));
        } else {
            response.setHeader("Cache-Control", "public,max-age=" + Integer.toString(ttl));
        }
    }

    public static JSONObject getJsConfig(ContainerConfig config, GadgetContext context, Collection<String> features) {
        JSONObject containerFeatures = config.getJsonObject(context.getContainer(), "gadgets.features");
        if (containerFeatures != null) {
            String[] featArray = features.toArray(new String[features.size()]);
            return new JSONObject(containerFeatures, featArray);
        }
        return new JSONObject();
    }

    static {
        HttpUtil.setTimeSource(new TimeSource());
    }
}

