/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.spec.View;

public class DefaultContentRewriterRegistry
implements ContentRewriterRegistry {
    protected final List<ContentRewriter> rewriters;
    protected final GadgetHtmlParser htmlParser;

    @Inject
    public DefaultContentRewriterRegistry(List<ContentRewriter> rewriters, GadgetHtmlParser htmlParser) {
        if (rewriters == null) {
            rewriters = Collections.emptyList();
        }
        this.rewriters = Lists.newLinkedList(rewriters);
        this.htmlParser = htmlParser;
    }

    @Override
    public String rewriteGadget(Gadget gadget, View currentView) throws GadgetException {
        if (currentView == null) {
            return null;
        }
        MutableContent mc = new MutableContent(this.htmlParser, currentView.getContent());
        for (ContentRewriter rewriter : this.rewriters) {
            rewriter.rewrite(gadget, mc);
        }
        return mc.getContent();
    }

    @Override
    public String rewriteGadget(Gadget gadget, String content) {
        if (content == null) {
            return null;
        }
        MutableContent mc = new MutableContent(this.htmlParser, content);
        for (ContentRewriter rewriter : this.rewriters) {
            rewriter.rewrite(gadget, mc);
        }
        return mc.getContent();
    }

    @Override
    public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp) {
        MutableContent mc = new MutableContent(this.htmlParser, resp);
        boolean wasRewritten = false;
        for (ContentRewriter rewriter : this.rewriters) {
            wasRewritten |= rewriter.rewrite(req, resp, mc) != null;
        }
        if (wasRewritten) {
            return new HttpResponseBuilder(resp).setResponseString(mc.getContent()).create();
        }
        return resp;
    }

    protected List<ContentRewriter> getRewriters() {
        return this.rewriters;
    }
}

