/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;

public class CSSContentRewriter
implements ContentRewriter {
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final String proxyBaseNoGadget;

    @Inject
    public CSSContentRewriter(ContentRewriterFeatureFactory rewriterFeatureFactory, @Named(value="shindig.content-rewrite.proxy-url") String proxyBaseNoGadget) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.proxyBaseNoGadget = proxyBaseNoGadget;
    }

    @Override
    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        return null;
    }

    @Override
    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        if (!RewriterUtils.isCss(request, original)) {
            return null;
        }
        ContentRewriterFeature feature = this.rewriterFeatureFactory.get(request);
        content.setContent(CssRewriter.rewrite(content.getContent(), request.getUri(), this.createLinkRewriter(request.getGadget(), feature)));
        return RewriterResults.cacheableIndefinitely();
    }

    protected LinkRewriter createLinkRewriter(Uri gadgetUri, ContentRewriterFeature feature) {
        return new ProxyingLinkRewriter(gadgetUri, feature, this.proxyBaseNoGadget);
    }
}

