/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.render.HtmlRenderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static final Logger LOG = LoggerFactory.getLogger((String)Renderer.class.getName());
    private final Processor processor;
    private final HtmlRenderer renderer;
    private final ContainerConfig containerConfig;
    private final LockedDomainService lockedDomainService;

    @Inject
    public Renderer(Processor processor, HtmlRenderer renderer, ContainerConfig containerConfig, LockedDomainService lockedDomainService) {
        this.processor = processor;
        this.renderer = renderer;
        this.containerConfig = containerConfig;
        this.lockedDomainService = lockedDomainService;
    }

    public RenderingResults render(GadgetContext context) {
        if (!this.validateParent(context)) {
            return RenderingResults.error("Unsupported parent parameter. Check your container code.");
        }
        try {
            Gadget gadget = this.processor.process(context);
            if (gadget.getCurrentView() == null) {
                return RenderingResults.error("Unable to locate an appropriate view in this gadget. Requested: '" + StringEscapeUtils.escapeHtml4((String)gadget.getContext().getView()) + "' Available: " + StringEscapeUtils.escapeHtml4((String)gadget.getSpec().getViews().keySet().toString()));
            }
            if (gadget.getCurrentView().getType() == View.ContentType.URL) {
                return RenderingResults.mustRedirect(this.getRedirect(gadget));
            }
            GadgetSpec spec = gadget.getSpec();
            if (!this.lockedDomainService.gadgetCanRender(context.getHost(), spec, context.getContainer())) {
                return RenderingResults.mustRedirect(this.getRedirect(gadget));
            }
            return RenderingResults.ok(this.renderer.render(gadget));
        }
        catch (RenderingException e) {
            return this.logError(context.getUrl(), e);
        }
        catch (ProcessingException e) {
            return this.logError(context.getUrl(), e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof GadgetException) {
                return this.logError(context.getUrl(), e.getCause());
            }
            throw e;
        }
    }

    private RenderingResults logError(URI gadgetUrl, Throwable t) {
        LOG.info("Failed to render gadget " + gadgetUrl + ": " + t.getMessage());
        return RenderingResults.error(t.getMessage());
    }

    private boolean validateParent(GadgetContext context) {
        String container = context.getContainer();
        String parent = context.getParameter("parent");
        if (parent == null) {
            return true;
        }
        try {
            JSONArray parents = this.containerConfig.getJsonArray(container, "gadgets.parent");
            if (parents == null) {
                return true;
            }
            int j = parents.length();
            for (int i = 0; i < j; ++i) {
                if (!Pattern.matches(parents.getString(i), parent)) continue;
                return true;
            }
        }
        catch (JSONException e) {
            LOG.warn("Configuration error", (Throwable)e);
        }
        return false;
    }

    private Uri getRedirect(Gadget gadget) {
        View view = gadget.getCurrentView();
        if (view.getType() == View.ContentType.URL) {
            return gadget.getCurrentView().getHref();
        }
        return null;
    }
}

