/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLEntities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NekoSerializer
extends HtmlSerializer {
    @Override
    public String serializeImpl(Document doc) {
        try {
            StringWriter sw = NekoSerializer.createWriter(doc);
            if (doc.getDoctype() != null) {
                NekoSerializer.outputDocType(doc.getDoctype(), sw);
            }
            NekoSerializer.serialize(doc, sw);
            String s = sw.toString();
            return s;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static void serialize(Node n, Appendable output) throws IOException {
        switch (n.getNodeType()) {
            case 4: {
                break;
            }
            case 8: {
                output.append("<!--").append(n.getNodeValue()).append("-->");
                break;
            }
            case 9: {
                NekoSerializer.serialize(((Document)n).getDocumentElement(), output);
                break;
            }
            case 1: {
                Element elem = (Element)n;
                HTMLElements.Element htmlElement = HTMLElements.getElement((String)elem.getNodeName());
                NodeList children = elem.getChildNodes();
                NekoSerializer.printStartElement(elem, output);
                for (int i = 0; i < children.getLength(); ++i) {
                    NekoSerializer.serialize(children.item(i), output);
                }
                if (htmlElement.isEmpty()) break;
                output.append("</").append(elem.getNodeName()).append('>');
                break;
            }
            case 5: {
                output.append("&").append(n.getNodeName()).append(";");
                break;
            }
            case 3: {
                output.append(n.getTextContent());
            }
        }
    }

    public static void outputDocType(DocumentType docType, Appendable output) throws IOException {
        output.append("<!DOCTYPE ");
        output.append(docType.getOwnerDocument().getDocumentElement().getNodeName());
        if (docType.getPublicId() != null && docType.getPublicId().length() > 0) {
            output.append(" ");
            output.append("PUBLIC ").append('\"').append(docType.getPublicId()).append('\"');
        }
        if (docType.getSystemId() != null && docType.getSystemId().length() > 0) {
            output.append(" ");
            output.append('\"').append(docType.getSystemId()).append('\"');
        }
        output.append(">\n");
    }

    public static void printStartElement(Element elem, Appendable output) throws IOException {
        output.append("<").append(elem.getTagName());
        NamedNodeMap attributes = elem.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            output.append(' ').append(attr.getNodeName());
            if (attr.getNodeValue() == null || attr.getNodeValue().length() <= 0) continue;
            output.append("=\"");
            NekoSerializer.printAttributeValue(attr.getNodeValue(), output);
            output.append('\"');
        }
        output.append(">");
    }

    public static void printAttributeValue(String text, Appendable output) throws IOException {
        int length = text.length();
        for (int j = 0; j < length; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(c);
        }
    }

    public static void printEscapedText(CharSequence text, Appendable output) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String entity = HTMLEntities.get((int)c);
            if (entity != null) {
                output.append('&').append(entity).append(";");
                continue;
            }
            output.append(c);
        }
    }
}

