/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.StringReader;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSerializer;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Singleton
public class NekoHtmlParser
extends GadgetHtmlParser {
    private final DOMImplementation documentProvider;

    @Inject
    public NekoHtmlParser(DOMImplementation documentProvider) {
        this.documentProvider = documentProvider;
    }

    @Override
    public Document parseDomImpl(String source) throws GadgetException {
        try {
            Document document = this.parseFragment(source);
            HtmlSerializer.attach(document, new NekoSerializer(), source);
            return document;
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }

    private Document parseFragment(String source) throws SAXException, IOException {
        InputSource input = new InputSource(new StringReader(source));
        if (NekoHtmlParser.attemptFullDocParseFirst(source)) {
            DOMParser parser = new DOMParser();
            parser.setProperty("http://apache.org/xml/properties/dom/document-class-name", (Object)"org.apache.xerces.dom.DocumentImpl");
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"default");
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
            parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            parser.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser.parse(input);
            return parser.getDocument();
        }
        Document htmlDoc = this.documentProvider.createDocument(null, null, null);
        htmlDoc.setStrictErrorChecking(false);
        DOMFragmentParser parser = new DOMFragmentParser();
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"default");
        parser.setFeature("http://cyberneko.org/html/features/document-fragment", true);
        parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
        parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        parser.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
        DocumentFragment fragment = htmlDoc.createDocumentFragment();
        parser.parse(input, fragment);
        this.normalizeFragment(htmlDoc, fragment);
        return htmlDoc;
    }
}

