/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.oauth.OAuthArguments;

public class HttpRequest {
    public static final String DOS_PREVENTION_HEADER = "X-shindig-dos";
    static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=utf-8";
    private String method = "GET";
    private Uri uri;
    private final Map<String, List<String>> headers = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private byte[] postBody = ArrayUtils.EMPTY_BYTE_ARRAY;
    private boolean ignoreCache;
    private int cacheTtl = -1;
    private boolean followRedirects = true;
    private Uri gadget;
    private String container = "default";
    private SecurityToken securityToken;
    private OAuthArguments oauthArguments;
    private AuthType authType;
    private String rewriteMimeType;

    public HttpRequest(Uri uri) {
        this.uri = uri;
        this.authType = AuthType.NONE;
        this.addHeader(DOS_PREVENTION_HEADER, "on");
    }

    public HttpRequest(HttpRequest request) {
        this.method = request.method;
        this.uri = request.uri;
        this.headers.putAll(request.headers);
        this.postBody = request.postBody;
        this.ignoreCache = request.ignoreCache;
        this.cacheTtl = request.cacheTtl;
        this.gadget = request.gadget;
        this.container = request.container;
        this.securityToken = request.securityToken;
        if (request.oauthArguments != null) {
            this.oauthArguments = new OAuthArguments(request.oauthArguments);
        }
        this.authType = request.authType;
        this.rewriteMimeType = request.rewriteMimeType;
        this.followRedirects = request.followRedirects;
    }

    public HttpRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpRequest setUri(Uri uri) {
        this.uri = uri;
        return this;
    }

    public HttpRequest addHeader(String name, String value) {
        ArrayList values = this.headers.get(name);
        if (values == null) {
            values = Lists.newArrayList();
            this.headers.put(name, values);
        }
        values.add(value);
        return this;
    }

    public HttpRequest setHeader(String name, String value) {
        this.headers.put(name, Lists.newArrayList((Object[])new String[]{value}));
        return this;
    }

    public HttpRequest addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpRequest addAllHeaders(Map<String, ? extends List<String>> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public List<String> removeHeader(String name) {
        return this.headers.remove(name);
    }

    public HttpRequest setPostBody(byte[] postBody) {
        if (postBody == null) {
            this.postBody = ArrayUtils.EMPTY_BYTE_ARRAY;
        } else {
            this.postBody = new byte[postBody.length];
            System.arraycopy(postBody, 0, this.postBody, 0, postBody.length);
        }
        return this;
    }

    public HttpRequest setPostBody(InputStream is) throws IOException {
        this.postBody = IOUtils.toByteArray((InputStream)is);
        return this;
    }

    public HttpRequest setIgnoreCache(boolean ignoreCache) {
        this.ignoreCache = ignoreCache;
        if (ignoreCache) {
            this.headers.put("Pragma", Lists.newArrayList((Object[])new String[]{"no-cache"}));
        }
        return this;
    }

    public HttpRequest setCacheTtl(int cacheTtl) {
        this.cacheTtl = cacheTtl;
        return this;
    }

    public HttpRequest setGadget(Uri gadget) {
        this.gadget = gadget;
        return this;
    }

    public HttpRequest setContainer(String container) {
        this.container = container;
        return this;
    }

    public HttpRequest setSecurityToken(SecurityToken securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    public HttpRequest setOAuthArguments(OAuthArguments oauthArguments) {
        this.oauthArguments = oauthArguments;
        return this;
    }

    public HttpRequest setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest setAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public HttpRequest setRewriteMimeType(String rewriteMimeType) {
        this.rewriteMimeType = rewriteMimeType;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        List<String> match = this.headers.get(name);
        if (match == null) {
            return Collections.emptyList();
        }
        return match;
    }

    public String getHeader(String name) {
        List<String> headerList = this.getHeaders(name);
        if (headerList.isEmpty()) {
            return null;
        }
        return headerList.get(0);
    }

    public String getContentType() {
        String type = this.getHeader("Content-Type");
        if (type == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        return type;
    }

    public InputStream getPostBody() {
        return new ByteArrayInputStream(this.postBody);
    }

    public String getPostBodyAsString() {
        try {
            return new String(this.postBody, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return "";
        }
    }

    public int getPostBodyLength() {
        return this.postBody.length;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public int getCacheTtl() {
        return this.cacheTtl;
    }

    public Uri getGadget() {
        return this.gadget;
    }

    public String getContainer() {
        return this.container;
    }

    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public OAuthArguments getOAuthArguments() {
        return this.oauthArguments;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getRewriteMimeType() {
        return this.rewriteMimeType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.method);
        buf.append(' ').append(this.uri.getPath()).append((String)(this.uri.getQuery() == null ? "" : "?" + this.uri.getQuery())).append("\n\n");
        buf.append("Host: ").append(this.uri.getAuthority()).append('\n');
        buf.append("X-Shindig-AuthType: ").append((Object)this.authType).append('\n');
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                buf.append(name).append(": ").append(value).append('\n');
            }
        }
        buf.append('\n');
        buf.append(this.getPostBodyAsString());
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)obj;
            return this.method.equals(req.method) && this.uri.equals((Object)req.uri) && this.authType.equals((Object)req.authType) && Arrays.equals(this.postBody, req.postBody) && this.headers.equals(req.headers);
        }
        return false;
    }
}

