/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.json.JSONArray;

public class HttpCacheKey {
    private Map<String, String> data = Maps.newHashMap();
    private boolean cacheable;

    public HttpCacheKey(HttpRequest request) {
        this.setCacheable(true);
        if (!"GET".equals(request.getMethod()) || request.getIgnoreCache() || request.getHeader("Authorization") != null) {
            this.setCacheable(false);
        }
        this.set("method", request.getMethod());
        this.set("url", request.getUri().toString());
        this.set("authType", request.getAuthType().toString());
        this.set("ownerId", HttpCacheKey.getOwnerId(request));
        this.set("viewerId", HttpCacheKey.getViewerId(request));
        this.set("tokenOwner", HttpCacheKey.getTokenOwner(request));
        this.set("appUrl", HttpCacheKey.getAppUrl(request));
        this.set("instanceId", HttpCacheKey.getInstanceId(request));
        this.set("serviceName", HttpCacheKey.getServiceName(request));
        this.set("tokenName", HttpCacheKey.getTokenName(request));
    }

    public void set(String key, String value) {
        this.data.put(key, value);
    }

    public void remove(String key) {
        this.data.remove(key);
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String toString() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.data.keySet());
        Collections.sort(list);
        JSONArray json = new JSONArray();
        for (String key : list) {
            json.put(Collections.singletonMap(key, this.data.get(key)));
        }
        return json.toString();
    }

    protected static String getOwnerId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getOAuthArguments().getSignOwner()) {
            String ownerId = request.getSecurityToken().getOwnerId();
            return ownerId == null ? "" : ownerId;
        }
        return null;
    }

    protected static String getViewerId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getOAuthArguments().getSignViewer()) {
            String viewerId = request.getSecurityToken().getViewerId();
            return viewerId == null ? "" : viewerId;
        }
        return null;
    }

    protected static String getTokenOwner(HttpRequest request) {
        SecurityToken st = request.getSecurityToken();
        if (request.getAuthType() != AuthType.NONE && st.getOwnerId() != null && st.getOwnerId().equals(st.getViewerId()) && request.getOAuthArguments().mayUseToken()) {
            return st.getOwnerId();
        }
        return null;
    }

    protected static String getAppUrl(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getSecurityToken().getAppUrl();
        }
        return null;
    }

    protected static String getInstanceId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getSecurityToken().getModuleId();
        }
        return null;
    }

    protected static String getServiceName(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getOAuthArguments().getServiceName();
        }
        return null;
    }

    protected static String getTokenName(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getOAuthArguments().getTokenName();
        }
        return null;
    }
}

