/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

@Singleton
public class BasicHttpFetcher
implements HttpFetcher {
    private static final int CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_MAX_OBJECT_SIZE = 0x100000;
    private final HttpCache cache;
    private Provider<Proxy> proxyProvider;

    public BasicHttpFetcher(HttpCache cache, int maxObjSize) {
        this.cache = cache;
    }

    @Inject
    public BasicHttpFetcher(HttpCache cache) {
        this(cache, 0x100000);
    }

    @Inject(optional=true)
    public void setProxyProvider(Provider<Proxy> proxyProvider) {
        this.proxyProvider = proxyProvider;
    }

    private HttpURLConnection getConnection(HttpRequest request) throws IOException {
        URL url = new URL(request.getUri().toString());
        HttpURLConnection fetcher = (HttpURLConnection)(this.proxyProvider == null ? url.openConnection() : url.openConnection((Proxy)this.proxyProvider.get()));
        fetcher.setConnectTimeout(5000);
        fetcher.setRequestProperty("Accept-Encoding", "gzip, deflate");
        fetcher.setInstanceFollowRedirects(request.getFollowRedirects());
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            fetcher.setRequestProperty(entry.getKey(), StringUtils.join((Iterable)entry.getValue(), (char)','));
        }
        fetcher.setDefaultUseCaches(!request.getIgnoreCache());
        return fetcher;
    }

    private HttpResponse makeResponse(HttpURLConnection fetcher) throws IOException {
        HashMap headers = Maps.newHashMap(fetcher.getHeaderFields());
        headers.remove(null);
        int responseCode = fetcher.getResponseCode();
        InputStream baseIs = null;
        try {
            baseIs = fetcher.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (baseIs == null) {
            baseIs = fetcher.getErrorStream();
        }
        if (baseIs == null) {
            baseIs = new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY);
        }
        String encoding = fetcher.getContentEncoding();
        InputStream is = null;
        if (encoding == null) {
            is = baseIs;
        } else if (encoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(baseIs);
        } else if (encoding.equalsIgnoreCase("deflate")) {
            Inflater inflater = new Inflater(true);
            is = new InflaterInputStream(baseIs, inflater);
        }
        byte[] body = IOUtils.toByteArray((InputStream)is);
        return new HttpResponseBuilder().setHttpStatusCode(responseCode).setResponse(body).addAllHeaders(headers).create();
    }

    @Override
    public HttpResponse fetch(HttpRequest request) {
        HttpCacheKey cacheKey = new HttpCacheKey(request);
        HttpResponse response = this.cache.getResponse(cacheKey, request);
        if (response != null) {
            return response;
        }
        try {
            HttpURLConnection fetcher = this.getConnection(request);
            fetcher.setRequestMethod(request.getMethod());
            if (!"GET".equals(request.getMethod())) {
                fetcher.setUseCaches(false);
            }
            fetcher.setRequestProperty("Content-Length", String.valueOf(request.getPostBodyLength()));
            if (request.getPostBodyLength() > 0) {
                fetcher.setDoOutput(true);
                IOUtils.copy((InputStream)request.getPostBody(), (OutputStream)fetcher.getOutputStream());
            }
            response = this.makeResponse(fetcher);
            return this.cache.addResponse(cacheKey, request, response);
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException || e instanceof SocketException) {
                return HttpResponse.timeout();
            }
            return HttpResponse.error();
        }
    }
}

