/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

public abstract class AbstractHttpCache
implements HttpCache {
    protected abstract HttpResponse getResponseImpl(String var1);

    protected abstract void addResponseImpl(String var1, HttpResponse var2);

    protected abstract HttpResponse removeResponseImpl(String var1);

    @Override
    public final HttpResponse getResponse(HttpCacheKey key, HttpRequest request) {
        String keyString;
        HttpResponse cached;
        if (key.isCacheable() && this.responseStillUsable(cached = this.getResponseImpl(keyString = key.toString()))) {
            return cached;
        }
        return null;
    }

    @Override
    public HttpResponse addResponse(HttpCacheKey key, HttpRequest request, HttpResponse response) {
        if (key.isCacheable() && response != null) {
            HttpResponseBuilder responseBuilder = new HttpResponseBuilder(response);
            int forcedTtl = request.getCacheTtl();
            if (forcedTtl != -1) {
                responseBuilder.setCacheTtl(forcedTtl);
            }
            response = responseBuilder.create();
            this.addResponseImpl(key.toString(), response);
        }
        return response;
    }

    @Override
    public HttpResponse removeResponse(HttpCacheKey key) {
        String keyString = key.toString();
        HttpResponse response = this.getResponseImpl(keyString);
        this.removeResponseImpl(keyString);
        if (this.responseStillUsable(response)) {
            return response;
        }
        return null;
    }

    protected boolean responseStillUsable(HttpResponse response) {
        if (response == null) {
            return false;
        }
        return response.getCacheExpiration() > System.currentTimeMillis();
    }
}

