/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.JsFeatureLoader;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GadgetFeatureRegistry {
    private final Map<String, GadgetFeature> features;
    private final Map<String, GadgetFeature> core;
    final Map<Set<String>, Collection<GadgetFeature>> cache = new MapMaker().makeMap();
    private boolean graphComplete = false;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.apache.shindig.gadgets");

    @Inject
    public GadgetFeatureRegistry(@Named(value="shindig.features.default") String featureFiles, HttpFetcher httpFetcher) throws GadgetException {
        this.features = Maps.newHashMap();
        this.core = Maps.newHashMap();
        if (featureFiles != null) {
            JsFeatureLoader loader = new JsFeatureLoader(httpFetcher);
            loader.loadFeatures(featureFiles, this);
        }
    }

    public void register(GadgetFeature feature) {
        if (this.graphComplete) {
            throw new IllegalStateException("register should never be invoked after calling getLibraries");
        }
        logger.info("Registering feature: " + feature.getName());
        if (this.isCore(feature)) {
            this.core.put(feature.getName(), feature);
            for (GadgetFeature feat : this.features.values()) {
                feat.addDependency(feature.getName());
            }
        } else {
            feature.addDependencies(this.core.keySet());
        }
        this.features.put(feature.getName(), feature);
    }

    private boolean isCore(GadgetFeature feature) {
        return feature.getName().startsWith("core");
    }

    public Collection<GadgetFeature> getAllFeatures() {
        return Collections.unmodifiableCollection(this.features.values());
    }

    public Collection<GadgetFeature> getFeatures(Collection<String> needed) {
        return this.getFeatures(needed, null);
    }

    public Collection<GadgetFeature> getFeatures(Collection<String> needed, Collection<String> unsupported) {
        this.graphComplete = true;
        Set<String> neededSet = needed.isEmpty() ? this.core.keySet() : ImmutableSet.copyOf(needed);
        Collection<GadgetFeature> libCache = this.cache.get(neededSet);
        if (libCache != null) {
            return libCache;
        }
        LinkedList ret = Lists.newLinkedList();
        this.populateDependencies((Collection<String>)neededSet, ret);
        if (unsupported != null) {
            Iterator iterator = neededSet.iterator();
            while (iterator.hasNext()) {
                String feature = (String)iterator.next();
                if (this.features.containsKey(feature)) continue;
                unsupported.add(feature);
            }
        }
        if (unsupported == null || unsupported.isEmpty()) {
            this.cache.put(neededSet, Collections.unmodifiableList(ret));
            logger.info("Added to cache. Size is now: " + this.cache.size());
        }
        return ret;
    }

    private void populateDependencies(Collection<String> needed, List<GadgetFeature> deps) {
        for (String feature : needed) {
            GadgetFeature feat = this.features.get(feature);
            if (feat == null || deps.contains(feat)) continue;
            this.populateDependencies(feat.getDependencies(), deps);
            deps.add(feat);
        }
    }
}

