/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.RenderingContext;

public class GadgetFeature {
    private final String name;
    private final Map<RenderingContext, Map<String, List<JsLibrary>>> libraries;
    private final Collection<String> dependencies;

    public String getName() {
        return this.name;
    }

    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(String dependency) {
        Collection<String> collection = this.dependencies;
        synchronized (collection) {
            this.dependencies.add(dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencies(Collection<String> dependencies) {
        Collection<String> collection = this.dependencies;
        synchronized (collection) {
            this.dependencies.addAll(dependencies);
        }
    }

    public List<JsLibrary> getJsLibraries(RenderingContext context, String container) {
        List<Object> libs = null;
        if (context == null) {
            libs = Lists.newLinkedList();
            for (Map<String, List<JsLibrary>> ctx : this.libraries.values()) {
                for (List<JsLibrary> lib : ctx.values()) {
                    libs.addAll(lib);
                }
            }
        } else {
            Map<String, List<JsLibrary>> contextLibs = this.libraries.get((Object)context);
            if (contextLibs != null && (libs = contextLibs.get(container)) == null) {
                libs = contextLibs.get("default");
            }
        }
        if (libs == null) {
            return Collections.emptyList();
        }
        return libs;
    }

    public GadgetFeature(String name, List<JsLibrary> libraries, Collection<String> dependencies) {
        this.name = name;
        this.libraries = Maps.newEnumMap(RenderingContext.class);
        for (RenderingContext context : RenderingContext.values()) {
            HashMap container = Maps.newHashMap();
            container.put("default", libraries);
            this.libraries.put(context, container);
        }
        this.dependencies = dependencies;
    }

    public GadgetFeature(String name, Map<RenderingContext, Map<String, List<JsLibrary>>> libraries, Collection<String> dependencies) {
        this.name = name;
        this.libraries = libraries;
        this.dependencies = dependencies;
    }
}

