/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Locale;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMessageBundleFactory
implements MessageBundleFactory {
    private static final Locale ALL_ALL = new Locale("all", "ALL");
    public static final String CACHE_NAME = "messageBundles";
    static final Logger LOG = LoggerFactory.getLogger((String)DefaultMessageBundleFactory.class.getName());
    private final HttpFetcher fetcher;
    final SoftExpiringCache<String, MessageBundle> cache;
    private final long refresh;

    @Inject
    public DefaultMessageBundleFactory(HttpFetcher fetcher, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh) {
        this.fetcher = fetcher;
        Cache baseCache = cacheProvider.createCache(CACHE_NAME);
        this.cache = new SoftExpiringCache(baseCache);
        this.refresh = refresh;
    }

    @Override
    public MessageBundle getBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        MessageBundle bundle;
        if (ignoreCache) {
            return this.getNestedBundle(spec, locale, true);
        }
        String key = spec.getUrl().toString() + "." + locale.toString();
        SoftExpiringCache.CachedObject cached = this.cache.getElement((Object)key);
        if (cached == null || cached.isExpired) {
            try {
                bundle = this.getNestedBundle(spec, locale, ignoreCache);
            }
            catch (GadgetException e) {
                if (cached != null) {
                    LOG.info("MessageBundle fetch failed for " + key + " - using cached.");
                    bundle = (MessageBundle)cached.obj;
                }
                LOG.info("MessageBundle fetch failed for " + key + " - using default.");
                bundle = MessageBundle.EMPTY;
            }
            this.cache.addElement((Object)key, (Object)bundle, this.refresh);
        } else {
            bundle = (MessageBundle)cached.obj;
        }
        return bundle;
    }

    private MessageBundle getNestedBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        MessageBundle parent = this.getParentBundle(spec, locale, ignoreCache);
        MessageBundle child = null;
        LocaleSpec localeSpec = spec.getModulePrefs().getLocale(locale);
        if (localeSpec == null) {
            return parent == null ? MessageBundle.EMPTY : parent;
        }
        Uri messages = localeSpec.getMessages();
        child = messages == null || messages.toString().length() == 0 ? localeSpec.getMessageBundle() : this.fetchBundle(localeSpec, ignoreCache);
        return new MessageBundle(parent, child);
    }

    private MessageBundle getParentBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        if (locale.getLanguage().equalsIgnoreCase("all")) {
            return null;
        }
        if (locale.getCountry().equalsIgnoreCase("ALL")) {
            return this.getBundle(spec, ALL_ALL, ignoreCache);
        }
        return this.getBundle(spec, new Locale(locale.getLanguage(), "ALL"), ignoreCache);
    }

    protected MessageBundle fetchBundle(LocaleSpec locale, boolean ignoreCache) throws GadgetException {
        Uri url = locale.getMessages();
        HttpRequest request = new HttpRequest(url).setIgnoreCache(ignoreCache);
        request.setCacheTtl((int)(this.refresh / 1000L));
        HttpResponse response = this.fetcher.fetch(request);
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve message bundle xml. HTTP error " + response.getHttpStatusCode());
        }
        MessageBundle bundle = new MessageBundle(locale, response.getResponseAsString());
        return bundle;
    }
}

