/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.model.FilterOperation;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseRequestItem
implements RequestItem {
    protected final SecurityToken token;
    final BeanConverter converter;
    final Map<String, Object> parameters;
    final Map<String, FormDataItem> formItems;
    final BeanJsonConverter jsonConverter;
    Map<String, Object> attributes;

    public BaseRequestItem(Map<String, String[]> parameters, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
        this.token = token;
        this.converter = converter;
        this.parameters = Maps.newHashMap();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (entry.getValue() == null) {
                this.setParameter(entry.getKey(), null);
                continue;
            }
            if (entry.getValue().length == 1) {
                this.setParameter(entry.getKey(), entry.getValue()[0]);
                continue;
            }
            this.setParameter(entry.getKey(), Lists.newArrayList((Object[])entry.getValue()));
        }
        this.jsonConverter = jsonConverter;
        this.formItems = null;
    }

    public BaseRequestItem(JSONObject parameters, Map<String, FormDataItem> formItems, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
        try {
            this.parameters = Maps.newHashMap();
            Iterator keys = parameters.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.parameters.put(key, parameters.get(key));
            }
            this.token = token;
            this.converter = converter;
            this.formItems = formItems;
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), je);
        }
        this.jsonConverter = jsonConverter;
    }

    @Override
    public String getAppId() {
        String appId = this.getParameter("appId");
        if (appId != null && appId.equals("@app")) {
            return this.token.getAppId();
        }
        return appId;
    }

    @Override
    public Date getUpdatedSince() {
        String updatedSince = this.getParameter("updatedSince");
        if (updatedSince == null) {
            return null;
        }
        DateTime date = new DateTime((Object)updatedSince);
        return date.toDate();
    }

    @Override
    public String getSortBy() {
        return this.getParameter("sortBy");
    }

    @Override
    public SortOrder getSortOrder() {
        String sortOrder = this.getParameter("sortOrder");
        try {
            return sortOrder == null ? SortOrder.ascending : SortOrder.valueOf(sortOrder);
        }
        catch (IllegalArgumentException iae) {
            throw new ProtocolException(400, "Parameter sortOrder (" + sortOrder + ") is not valid.");
        }
    }

    @Override
    public String getFilterBy() {
        return this.getParameter("filterBy");
    }

    @Override
    public int getStartIndex() {
        String startIndex = this.getParameter("startIndex");
        try {
            return startIndex == null ? 0 : Integer.valueOf(startIndex);
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolException(400, "Parameter startIndex (" + startIndex + ") is not a number.");
        }
    }

    @Override
    public int getCount() {
        String count = this.getParameter("count");
        try {
            return count == null ? 20 : Integer.valueOf(count);
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolException(400, "Parameter count (" + count + ") is not a number.");
        }
    }

    @Override
    public FilterOperation getFilterOperation() {
        String filterOp = this.getParameter("filterOp");
        try {
            return filterOp == null ? FilterOperation.contains : FilterOperation.valueOf(filterOp);
        }
        catch (IllegalArgumentException iae) {
            throw new ProtocolException(400, "Parameter filterOp (" + filterOp + ") is not valid.");
        }
    }

    @Override
    public String getFilterValue() {
        String filterValue = this.getParameter("filterValue");
        return (String)Objects.firstNonNull((Object)filterValue, (Object)"");
    }

    @Override
    public Set<String> getFields() {
        return this.getFields(Collections.<String>emptySet());
    }

    @Override
    public Set<String> getFields(Set<String> defaultValue) {
        ImmutableSet result = ImmutableSet.copyOf(this.getListParameter("fields"));
        if (result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    @Override
    public SecurityToken getToken() {
        return this.token;
    }

    @Override
    public <T> T getTypedParameter(String parameterName, Class<T> dataTypeClass) {
        try {
            String json = this.getParameter(parameterName);
            if (json == null) {
                throw new ProtocolException(400, "missing data for " + parameterName);
            }
            return this.converter.convertToObject(json, dataTypeClass);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof JSONException) {
                throw new ProtocolException(400, e.getMessage());
            }
            throw e;
        }
    }

    public <T> T getOptionalTypedParameter(String parameterName, Class<T> dataTypeClass) {
        try {
            String json = this.getParameter(parameterName);
            if (json == null) {
                return null;
            }
            return this.converter.convertToObject(json, dataTypeClass);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof JSONException) {
                throw new ProtocolException(400, e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public <T> T getTypedRequest(Class<T> dataTypeClass) {
        try {
            return this.jsonConverter.convertToObject(new JSONObject(this.parameters).toString(), dataTypeClass);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof JSONException) {
                throw new ProtocolException(400, e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public String getParameter(String paramName) {
        Object param = this.parameters.get(paramName);
        if (param instanceof List) {
            if (((List)param).isEmpty()) {
                return null;
            }
            param = ((List)param).get(0);
        }
        if (param == null) {
            return null;
        }
        return param.toString();
    }

    @Override
    public String getParameter(String paramName, String defaultValue) {
        String param = this.getParameter(paramName);
        if (param == null) {
            return defaultValue;
        }
        return param;
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public List<String> getListParameter(String paramName) {
        Object param = this.parameters.get(paramName);
        if (param == null) {
            return Collections.emptyList();
        }
        if (param instanceof String && ((String)param).indexOf(44) != -1) {
            ImmutableList listParam = ImmutableList.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)((String)param)));
            this.parameters.put(paramName, listParam);
            return listParam;
        }
        if (param instanceof List) {
            return (List)param;
        }
        if (param instanceof JSONArray) {
            try {
                JSONArray jsonArray = (JSONArray)param;
                ArrayList returnVal = Lists.newArrayListWithCapacity((int)jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    returnVal.add(jsonArray.getString(i));
                }
                return returnVal;
            }
            catch (JSONException je) {
                throw new ProtocolException(400, je.getMessage(), je);
            }
        }
        return Lists.newArrayList((Object[])new String[]{param.toString()});
    }

    @VisibleForTesting
    public void setParameter(String paramName, Object paramValue) {
        if (paramValue instanceof String[]) {
            Object[] arr = (String[])paramValue;
            if (arr.length == 1) {
                this.parameters.put(paramName, arr[0]);
            } else {
                this.parameters.put(paramName, Lists.newArrayList((Object[])arr));
            }
        } else if (paramValue instanceof String) {
            String stringValue = (String)paramValue;
            if (stringValue.length() > 0) {
                this.parameters.put(paramName, stringValue);
            }
        } else {
            this.parameters.put(paramName, paramValue);
        }
    }

    @Override
    public FormDataItem getFormMimePart(String partName) {
        if (this.formItems != null) {
            return this.formItems.get(partName);
        }
        return null;
    }

    private Map<String, Object> getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        return this.attributes;
    }

    @Override
    public Object getAttribute(String val) {
        Preconditions.checkNotNull((Object)val);
        return this.getAttributeMap().get(val);
    }

    @Override
    public void setAttribute(String val, Object obj) {
        Preconditions.checkNotNull((Object)val);
        if (obj == null) {
            this.getAttributeMap().remove(val);
        } else {
            this.getAttributeMap().put(val, obj);
        }
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }
}

