/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.apache.shindig.expressions.Expressions;

public class DynamicConfigProperty
implements CharSequence {
    private static final String classname = DynamicConfigProperty.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final ELContext context;
    private final ValueExpression expression;

    public DynamicConfigProperty(String value, Expressions expressions, ELContext context) {
        this.context = context;
        this.expression = expressions.parse(value, String.class);
    }

    @Override
    public String toString() {
        try {
            return (String)this.expression.getValue(this.context);
        }
        catch (ELException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.logp(Level.WARNING, classname, "toString", "evalExpressionFailed", new Object[]{this.expression.getExpressionString()});
                LOG.logp(Level.WARNING, classname, "toString", "evalExpressionFailed", e);
            }
            return "";
        }
    }

    @Override
    public char charAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }
}

