/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.shindig.protocol.DefaultHandlerRegistry;
import org.apache.shindig.protocol.HandlerExecutionListener;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestHandler;
import org.apache.shindig.protocol.RpcHandler;
import org.apache.shindig.protocol.TestHandler;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultHandlerRegistryTest
extends Assert {
    private DefaultHandlerRegistry registry;
    private BeanJsonConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[0]));
        this.registry = new DefaultHandlerRegistry(null, this.converter, (HandlerExecutionListener)new HandlerExecutionListener.NoOpHandler());
        this.registry.addHandlers((Set)Sets.newHashSet((Object[])new Object[]{new TestHandler()}));
    }

    @Test
    public void testGetHandlerRPC() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRpcHandler(new JSONObject("{method : test.get}")));
    }

    @Test
    public void testGetHandlerRest() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRestHandler("/test/", "GET"));
    }

    @Test
    public void testOverrideHandlerRPC() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRpcHandler(new JSONObject("{method : test.overidden}")));
    }

    @Test
    public void testOverrideHandlerRPCName() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRpcHandler(new JSONObject("{method : test.override.rpcname}")));
    }

    @Test
    public void testOverrideHandlerRest() throws Exception {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRestHandler("/test/overidden/method/", "GET"));
    }

    @Test
    public void testGetForAliasHandler() {
        DefaultHandlerRegistryTest.assertNotNull((Object)this.registry.getRestHandler("/test", "GET"));
    }

    @Test
    public void testRpcHandler_serviceDoesntExist() throws Exception {
        JSONObject rpc = new JSONObject("{method : makebelieve.get}");
        RpcHandler rpcHandler = this.registry.getRpcHandler(rpc);
        try {
            Future future = rpcHandler.execute(null, null, null);
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Expect exception for missing method");
        }
        catch (ExecutionException t) {
            DefaultHandlerRegistryTest.assertSame(t.getCause().getClass(), ProtocolException.class);
            Assert.assertEquals((long)501L, (long)((ProtocolException)t.getCause()).getCode());
        }
        catch (Throwable t) {
            DefaultHandlerRegistryTest.fail((String)("Unexpected exception " + t.toString()));
        }
    }

    @Test
    public void testRestHandler_serviceDoesntExist() {
        RestHandler restHandler = this.registry.getRestHandler("/makebelieve", "GET");
        try {
            Future future = restHandler.execute((Map)Maps.newHashMap(), null, null, null);
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Expect exception for missing method");
        }
        catch (ExecutionException t) {
            DefaultHandlerRegistryTest.assertSame(t.getCause().getClass(), ProtocolException.class);
            Assert.assertEquals((long)501L, (long)((ProtocolException)t.getCause()).getCode());
        }
        catch (Throwable t) {
            DefaultHandlerRegistryTest.fail((String)("Unexpected exception " + t.toString()));
        }
    }

    @Test
    public void testNonFutureDispatch() throws Exception {
        RestHandler handler = this.registry.getRestHandler("/test", "GET");
        Future future = handler.execute((Map)Maps.newHashMap(), null, null, null);
        DefaultHandlerRegistryTest.assertEquals((Object)"GET_RESPONSE", future.get());
    }

    @Test
    public void testFutureDispatch() throws Exception {
        RestHandler handler = this.registry.getRestHandler("/test", "POST");
        Future future = handler.execute((Map)Maps.newHashMap(), null, null, null);
        DefaultHandlerRegistryTest.assertEquals((Object)"CREATE_RESPONSE", future.get());
    }

    @Test
    public void testRpcWithInputClassThatIsntRequestItem() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.echo, params: {value: 'Bob' }}");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, (BeanConverter)this.converter);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"ECHO: Bob");
    }

    @Test
    public void testRestWithInputClassThatIsntRequestItem() throws Exception {
        RestHandler handler = this.registry.getRestHandler("/test/echo", "GET");
        String[] value = new String[]{"Bob"};
        Future future = handler.execute((Map)ImmutableMap.of((Object)"value", (Object)value), null, null, (BeanConverter)this.converter);
        DefaultHandlerRegistryTest.assertEquals(future.get(), (Object)"ECHO: Bob");
    }

    @Test
    public void testNoArgumentClass() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.noArg }");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, (BeanConverter)this.converter);
        DefaultHandlerRegistryTest.assertEquals((Object)"No arguments from me!", future.get());
    }

    @Test
    public void testNonFutureException() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.exception }");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, null);
        try {
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Service method did not produce NullPointerException from Future");
        }
        catch (ExecutionException ee) {
            DefaultHandlerRegistryTest.assertSame(ee.getCause().getClass(), NullPointerException.class);
        }
    }

    @Test
    public void testFutureException() throws Exception {
        JSONObject rpc = new JSONObject("{ method : test.futureException }");
        RpcHandler handler = this.registry.getRpcHandler(rpc);
        Future future = handler.execute(null, null, null);
        try {
            future.get();
            DefaultHandlerRegistryTest.fail((String)"Service method did not produce ExecutionException from Future");
        }
        catch (ExecutionException ee) {
            DefaultHandlerRegistryTest.assertSame(ee.getCause().getClass(), ProtocolException.class);
        }
    }

    @Test
    public void testSupportedRpcServices() throws Exception {
        DefaultHandlerRegistryTest.assertEquals((Object)this.registry.getSupportedRpcServices(), (Object)Sets.newHashSet((Object[])new String[]{"test.create", "test.get", "test.overridden", "test.exception", "test.futureException", "test.override.rpcname", "test.echo", "test.noArg"}));
    }

    @Test
    public void testSupportedRestServices() throws Exception {
        DefaultHandlerRegistryTest.assertEquals((Object)this.registry.getSupportedRestServices(), (Object)Sets.newHashSet((Object[])new String[]{"GET /test/{someParam}/{someOtherParam}", "PUT /test/{someParam}/{someOtherParam}", "DELETE /test/{someParam}/{someOtherParam}", "POST /test/{someParam}/{someOtherParam}", "GET /test/overridden/method", "GET /test/echo"}));
    }

    @Test(expected=IllegalStateException.class)
    public void testAddNonService() {
        this.registry.addHandlers((Set)Sets.newHashSet((Object[])new Object[]{new Object()}));
    }

    @Test
    public void testRestPath() {
        DefaultHandlerRegistry.RestPath restPath = new DefaultHandlerRegistry.RestPath("/service/const1/{p1}/{p2}+/const2/{p3}", null);
        DefaultHandlerRegistry.RestInvocationWrapper wrapper = restPath.accept("service/const1/a/b,c/const2/d".split("/"));
        DefaultHandlerRegistryTest.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p1")), (Object[])new String[]{"a"});
        DefaultHandlerRegistryTest.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p2")), (Object[])new String[]{"b", "c"});
        DefaultHandlerRegistryTest.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p3")), (Object[])new String[]{"d"});
        wrapper = restPath.accept("service/const1/a/b/const2".split("/"));
        DefaultHandlerRegistryTest.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p1")), (Object[])new String[]{"a"});
        DefaultHandlerRegistryTest.assertArrayEquals((Object[])((Object[])wrapper.pathParams.get("p2")), (Object[])new String[]{"b"});
        DefaultHandlerRegistryTest.assertNull(wrapper.pathParams.get("p3"));
        DefaultHandlerRegistryTest.assertNull((Object)restPath.accept("service/const1/{p1}/{p2}+".split("/")));
        DefaultHandlerRegistryTest.assertNull((Object)restPath.accept("service/constmiss/{p1}/{p2}+/const2".split("/")));
    }

    @Test
    public void testRestPathOrdering() {
        DefaultHandlerRegistry.RestPath restPath1 = new DefaultHandlerRegistry.RestPath("/service/const1/{p1}/{p2}+/const2/{p3}", null);
        DefaultHandlerRegistry.RestPath restPath2 = new DefaultHandlerRegistry.RestPath("/service/{p1}/{p2}+/const2/{p3}", null);
        DefaultHandlerRegistry.RestPath restPath3 = new DefaultHandlerRegistry.RestPath("/service/const1/const2/{p1}/{p2}+/{p3}", null);
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable)restPath1, (Comparable)restPath2, (Comparable)restPath3);
        Iterator itr = sortedSet.iterator();
        DefaultHandlerRegistryTest.assertEquals(itr.next(), (Object)restPath3);
        DefaultHandlerRegistryTest.assertEquals(itr.next(), (Object)restPath1);
        DefaultHandlerRegistryTest.assertEquals(itr.next(), (Object)restPath2);
    }
}

