/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.etcd;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.constant.DefaultPathConstants;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.core.AbstractPathDataSyncService;
import org.apache.shenyu.sync.data.etcd.EtcdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdSyncDataService
extends AbstractPathDataSyncService {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdSyncDataService.class);
    private final EtcdClient etcdClient;
    private final ShenyuConfig shenyuConfig;

    public EtcdSyncDataService(ShenyuConfig shenyuConfig, EtcdClient etcdClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        super(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers);
        this.shenyuConfig = shenyuConfig;
        this.etcdClient = etcdClient;
        this.watcherData();
    }

    private void watcherData() {
        String configNamespace = "/" + this.shenyuConfig.getNamespace();
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/plugin")));
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/selector")));
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/rule")));
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/proxySelectorData")));
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/discoveryUpstream")));
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/auth")));
        this.watcherData0(DefaultPathConstants.handlePathData((String)String.join((CharSequence)"/", configNamespace, "/shenyu/metaData")));
    }

    private void watcherData0(String registerPath) {
        String configNamespace = "/" + this.shenyuConfig.getNamespace();
        this.etcdClient.watchChildChange(registerPath, (updatePath, updateValue) -> super.event(configNamespace, updatePath, updateValue, registerPath, AbstractPathDataSyncService.EventType.PUT), deletePath -> super.event(configNamespace, deletePath, null, registerPath, AbstractPathDataSyncService.EventType.DELETE));
        try {
            List<String> childrenKeys = this.etcdClient.getChildrenKeys(registerPath, "/");
            if (!ObjectUtils.isEmpty(childrenKeys)) {
                childrenKeys.forEach(nodePath -> {
                    String updatePath = String.join((CharSequence)"/", registerPath, nodePath);
                    String nodeData = this.etcdClient.get(updatePath);
                    super.event(configNamespace, updatePath, nodeData, registerPath, AbstractPathDataSyncService.EventType.PUT);
                });
            } else {
                LOG.info("etcd watcher path {} is empty", (Object)registerPath);
            }
        }
        catch (Exception e) {
            LOG.error("watcherData0 errors", (Throwable)e);
        }
    }

    public void close() {
        if (Objects.nonNull(this.etcdClient)) {
            this.etcdClient.close();
        }
    }
}

