/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.core.util.FileSize;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingSystemProperties;
import org.springframework.boot.logging.logback.RollingPolicySystemProperty;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.unit.DataSize;

public class LogbackLoggingSystemProperties
extends LoggingSystemProperties {
    private static final boolean JBOSS_LOGGING_PRESENT = ClassUtils.isPresent("org.jboss.logging.Logger", LogbackLoggingSystemProperties.class.getClassLoader());
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String ROLLINGPOLICY_FILE_NAME_PATTERN = RollingPolicySystemProperty.FILE_NAME_PATTERN.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String ROLLINGPOLICY_CLEAN_HISTORY_ON_START = RollingPolicySystemProperty.CLEAN_HISTORY_ON_START.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String ROLLINGPOLICY_MAX_FILE_SIZE = RollingPolicySystemProperty.MAX_FILE_SIZE.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String ROLLINGPOLICY_TOTAL_SIZE_CAP = RollingPolicySystemProperty.TOTAL_SIZE_CAP.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String ROLLINGPOLICY_MAX_HISTORY = RollingPolicySystemProperty.MAX_HISTORY.getEnvironmentVariableName();

    public LogbackLoggingSystemProperties(Environment environment2) {
        super(environment2);
    }

    public LogbackLoggingSystemProperties(Environment environment2, BiConsumer<String, String> setter) {
        super(environment2, setter);
    }

    public LogbackLoggingSystemProperties(Environment environment2, Function<String, String> defaultValueResolver, BiConsumer<String, String> setter) {
        super(environment2, defaultValueResolver, setter);
    }

    @Override
    protected Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    @Override
    protected void apply(LogFile logFile, PropertyResolver resolver) {
        super.apply(logFile, resolver);
        this.applyJBossLoggingProperties();
        this.applyRollingPolicyProperties(resolver);
    }

    private void applyJBossLoggingProperties() {
        if (JBOSS_LOGGING_PRESENT) {
            this.setSystemProperty("org.jboss.logging.provider", "slf4j");
        }
    }

    private void applyRollingPolicyProperties(PropertyResolver resolver) {
        this.applyRollingPolicy(RollingPolicySystemProperty.FILE_NAME_PATTERN, resolver);
        this.applyRollingPolicy(RollingPolicySystemProperty.CLEAN_HISTORY_ON_START, resolver);
        this.applyRollingPolicy(RollingPolicySystemProperty.MAX_FILE_SIZE, resolver, DataSize.class);
        this.applyRollingPolicy(RollingPolicySystemProperty.TOTAL_SIZE_CAP, resolver, DataSize.class);
        this.applyRollingPolicy(RollingPolicySystemProperty.MAX_HISTORY, resolver);
    }

    private void applyRollingPolicy(RollingPolicySystemProperty property, PropertyResolver resolver) {
        this.applyRollingPolicy(property, resolver, String.class);
    }

    private <T> void applyRollingPolicy(RollingPolicySystemProperty property, PropertyResolver resolver, Class<T> type) {
        T value = this.getProperty(resolver, property.getApplicationPropertyName(), type);
        T t2 = value = value != null ? value : this.getProperty(resolver, property.getDeprecatedApplicationPropertyName(), type);
        if (value != null) {
            Object object;
            if (value instanceof DataSize) {
                DataSize dataSize = (DataSize)value;
                object = dataSize.toBytes();
            } else {
                object = value;
            }
            String stringValue = String.valueOf(object);
            this.setSystemProperty(property.getEnvironmentVariableName(), stringValue);
        }
    }

    private <T> T getProperty(PropertyResolver resolver, String key, Class<T> type) {
        try {
            return resolver.getProperty(key, type);
        }
        catch (ConversionFailedException | ConverterNotFoundException ex) {
            if (type != DataSize.class) {
                throw ex;
            }
            String value = resolver.getProperty(key);
            return (T)DataSize.ofBytes(FileSize.valueOf(value).getSize());
        }
    }
}

