/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.TransactionProvider;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jooq.DefaultConfigurationCustomizer;
import org.springframework.boot.autoconfigure.jooq.ExceptionTranslatorExecuteListener;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.boot.autoconfigure.jooq.SpringTransactionProvider;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, TransactionAutoConfiguration.class})
@ConditionalOnClass(value={DSLContext.class})
@ConditionalOnBean(value={DataSource.class})
public class JooqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConnectionProvider.class})
    public DataSourceConnectionProvider dataSourceConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    @ConditionalOnBean(value={PlatformTransactionManager.class})
    @ConditionalOnMissingBean(value={TransactionProvider.class})
    public SpringTransactionProvider transactionProvider(PlatformTransactionManager txManager) {
        return new SpringTransactionProvider(txManager);
    }

    @Bean
    @Order(value=0)
    public DefaultExecuteListenerProvider jooqExceptionTranslatorExecuteListenerProvider(ExceptionTranslatorExecuteListener exceptionTranslatorExecuteListener) {
        return new DefaultExecuteListenerProvider((ExecuteListener)exceptionTranslatorExecuteListener);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionTranslatorExecuteListener.class})
    public ExceptionTranslatorExecuteListener jooqExceptionTranslator() {
        return ExceptionTranslatorExecuteListener.DEFAULT;
    }

    @org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={DSLContext.class})
    @EnableConfigurationProperties(value={JooqProperties.class})
    public static class DslContextConfiguration {
        @Bean
        public DefaultDSLContext dslContext(Configuration configuration) {
            return new DefaultDSLContext(configuration);
        }

        @Bean
        @ConditionalOnMissingBean(value={Configuration.class})
        public DefaultConfiguration jooqConfiguration(JooqProperties properties, ConnectionProvider connectionProvider, DataSource dataSource, ObjectProvider<TransactionProvider> transactionProvider, ObjectProvider<ExecuteListenerProvider> executeListenerProviders, ObjectProvider<DefaultConfigurationCustomizer> configurationCustomizers) {
            DefaultConfiguration configuration = new DefaultConfiguration();
            configuration.set(properties.determineSqlDialect(dataSource));
            configuration.set(connectionProvider);
            transactionProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
            configuration.set((ExecuteListenerProvider[])executeListenerProviders.orderedStream().toArray(ExecuteListenerProvider[]::new));
            configurationCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(configuration));
            return configuration;
        }
    }
}

