/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.utils;

import com.ctrip.framework.apollo.core.utils.DeferredLogCache;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class DeferredLogger
implements Logger {
    private final Logger logger;
    private static final AtomicInteger state = new AtomicInteger(-1);

    public static void enable() {
        state.compareAndSet(-1, 1);
    }

    public static void disable() {
        state.set(0);
    }

    public static boolean isEnabled() {
        return state.get() == 1;
    }

    public static void replayTo() {
        DeferredLogger.disable();
        DeferredLogCache.replayTo();
    }

    public DeferredLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String s2) {
        this.logger.trace(s2);
    }

    @Override
    public void trace(String s2, Object o) {
        this.logger.trace(s2, o);
    }

    @Override
    public void trace(String s2, Object o, Object o1) {
        this.logger.trace(s2, o, o1);
    }

    @Override
    public void trace(String s2, Object ... objects) {
        this.logger.trace(s2, objects);
    }

    @Override
    public void trace(String s2, Throwable throwable) {
        this.logger.trace(s2, throwable);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String s2) {
        this.logger.trace(marker, s2);
    }

    @Override
    public void trace(Marker marker, String s2, Object o) {
        this.logger.trace(marker, s2, o);
    }

    @Override
    public void trace(Marker marker, String s2, Object o, Object o1) {
        this.logger.trace(marker, s2, o, o1);
    }

    @Override
    public void trace(Marker marker, String s2, Object ... objects) {
        this.logger.trace(marker, s2, objects);
    }

    @Override
    public void trace(Marker marker, String s2, Throwable throwable) {
        this.logger.trace(marker, s2, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String s2) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s2, new Object[0]);
        } else {
            this.logger.debug(s2);
        }
    }

    @Override
    public void debug(String s2, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s2, o);
        } else {
            this.logger.debug(s2, o);
        }
    }

    @Override
    public void debug(String s2, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s2, o, o1);
        } else {
            this.logger.debug(s2, o, o1);
        }
    }

    @Override
    public void debug(String s2, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s2, objects);
        } else {
            this.logger.debug(s2, objects);
        }
    }

    @Override
    public void debug(String s2, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.debug(this.logger, s2, throwable);
        } else {
            this.logger.debug(s2, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String s2) {
        this.logger.debug(marker, s2);
    }

    @Override
    public void debug(Marker marker, String s2, Object o) {
        this.logger.debug(marker, s2, o);
    }

    @Override
    public void debug(Marker marker, String s2, Object o, Object o1) {
        this.logger.debug(marker, s2, o, o1);
    }

    @Override
    public void debug(Marker marker, String s2, Object ... objects) {
        this.logger.debug(marker, s2, objects);
    }

    @Override
    public void debug(Marker marker, String s2, Throwable throwable) {
        this.logger.debug(marker, s2, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String s2) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s2, new Object[0]);
        } else {
            this.logger.info(s2);
        }
    }

    @Override
    public void info(String s2, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s2, o);
        } else {
            this.logger.info(s2, o);
        }
    }

    @Override
    public void info(String s2, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s2, o, o1);
        } else {
            this.logger.info(s2, o, o1);
        }
    }

    @Override
    public void info(String s2, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s2, objects);
        } else {
            this.logger.info(s2, objects);
        }
    }

    @Override
    public void info(String s2, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.info(this.logger, s2, throwable);
        } else {
            this.logger.info(s2, throwable);
        }
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String s2) {
        this.logger.info(marker, s2);
    }

    @Override
    public void info(Marker marker, String s2, Object o) {
        this.logger.info(marker, s2, o);
    }

    @Override
    public void info(Marker marker, String s2, Object o, Object o1) {
        this.logger.info(marker, s2, o, o1);
    }

    @Override
    public void info(Marker marker, String s2, Object ... objects) {
        this.logger.info(marker, s2, objects);
    }

    @Override
    public void info(Marker marker, String s2, Throwable throwable) {
        this.logger.info(marker, s2, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String s2) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s2, new Object[0]);
        } else {
            this.logger.warn(s2);
        }
    }

    @Override
    public void warn(String s2, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s2, o);
        } else {
            this.logger.warn(s2, o);
        }
    }

    @Override
    public void warn(String s2, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s2, objects);
        } else {
            this.logger.warn(s2, objects);
        }
    }

    @Override
    public void warn(String s2, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s2, o, o1);
        } else {
            this.logger.warn(s2, o, o1);
        }
    }

    @Override
    public void warn(String s2, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.warn(this.logger, s2, throwable);
        } else {
            this.logger.warn(s2, throwable);
        }
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String s2) {
        this.logger.warn(marker, s2);
    }

    @Override
    public void warn(Marker marker, String s2, Object o) {
        this.logger.warn(marker, s2, o);
    }

    @Override
    public void warn(Marker marker, String s2, Object o, Object o1) {
        this.logger.warn(marker, s2, o, o1);
    }

    @Override
    public void warn(Marker marker, String s2, Object ... objects) {
        this.logger.warn(marker, s2, objects);
    }

    @Override
    public void warn(Marker marker, String s2, Throwable throwable) {
        this.logger.warn(marker, s2, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String s2) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s2, new Object[0]);
        } else {
            this.logger.error(s2);
        }
    }

    @Override
    public void error(String s2, Object o) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s2, o);
        } else {
            this.logger.error(s2, o);
        }
    }

    @Override
    public void error(String s2, Object o, Object o1) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s2, o, o1);
        } else {
            this.logger.error(s2, o, o1);
        }
    }

    @Override
    public void error(String s2, Object ... objects) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s2, objects);
        } else {
            this.logger.error(s2, objects);
        }
    }

    @Override
    public void error(String s2, Throwable throwable) {
        if (DeferredLogger.isEnabled()) {
            DeferredLogCache.error(this.logger, s2, throwable);
        } else {
            this.logger.error(s2, throwable);
        }
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String s2) {
        this.logger.error(marker, s2);
    }

    @Override
    public void error(Marker marker, String s2, Object o) {
        this.logger.error(marker, s2, o);
    }

    @Override
    public void error(Marker marker, String s2, Object o, Object o1) {
        this.logger.error(marker, s2, o, o1);
    }

    @Override
    public void error(Marker marker, String s2, Object ... objects) {
        this.logger.error(marker, s2, objects);
    }

    @Override
    public void error(Marker marker, String s2, Throwable throwable) {
        this.logger.error(marker, s2, throwable);
    }
}

