/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.function;

import java.util.function.BiFunction;

public interface ThrowingBiFunction<T, U, R>
extends BiFunction<T, U, R> {
    public R applyWithException(T var1, U var2) throws Exception;

    @Override
    default public R apply(T t2, U u) {
        return this.apply(t2, u, RuntimeException::new);
    }

    default public R apply(T t2, U u, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        try {
            return this.applyWithException(t2, u);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw exceptionWrapper.apply(ex.getMessage(), ex);
        }
    }

    default public ThrowingBiFunction<T, U, R> throwing(final BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return new ThrowingBiFunction<T, U, R>(){

            @Override
            public R applyWithException(T t2, U u) throws Exception {
                return ThrowingBiFunction.this.applyWithException(t2, u);
            }

            @Override
            public R apply(T t2, U u) {
                return this.apply(t2, u, exceptionWrapper);
            }
        };
    }

    public static <T, U, R> ThrowingBiFunction<T, U, R> of(ThrowingBiFunction<T, U, R> function) {
        return function;
    }

    public static <T, U, R> ThrowingBiFunction<T, U, R> of(ThrowingBiFunction<T, U, R> function, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return function.throwing(exceptionWrapper);
    }
}

