/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.function.Supplier;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.context.aot.ApplicationContextInitializationCodeGenerator;
import org.springframework.context.aot.BeanFactoryInitializationAotContributions;
import org.springframework.context.aot.CglibClassHandler;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;

public class ApplicationContextAotGenerator {
    public ClassName processAheadOfTime(GenericApplicationContext applicationContext, GenerationContext generationContext) {
        return this.withCglibClassHandler(new CglibClassHandler(generationContext), () -> {
            applicationContext.refreshForAotProcessing(generationContext.getRuntimeHints());
            ApplicationContextInitializationCodeGenerator codeGenerator = new ApplicationContextInitializationCodeGenerator(applicationContext, generationContext);
            DefaultListableBeanFactory beanFactory = applicationContext.getDefaultListableBeanFactory();
            new BeanFactoryInitializationAotContributions(beanFactory).applyTo(generationContext, codeGenerator);
            return codeGenerator.getGeneratedClass().getName();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withCglibClassHandler(CglibClassHandler cglibClassHandler, Supplier<T> task) {
        try {
            ReflectUtils.setLoadedClassHandler(cglibClassHandler::handleLoadedClass);
            ReflectUtils.setGeneratedClassHandler(cglibClassHandler::handleGeneratedClass);
            T t2 = task.get();
            return t2;
        }
        finally {
            ReflectUtils.setLoadedClassHandler(null);
            ReflectUtils.setGeneratedClassHandler(null);
        }
    }
}

