/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.JdbcSessionDataSourceScriptDatabaseInitializer;
import org.springframework.boot.autoconfigure.session.JdbcSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.sql.init.OnDatabaseInitializationCondition;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JdbcTemplate.class, JdbcIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={JdbcSessionProperties.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class, JdbcHttpSessionConfiguration.class})
class JdbcSessionConfiguration {
    JdbcSessionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={JdbcSessionDataSourceScriptDatabaseInitializer.class})
    @Conditional(value={OnJdbcSessionDatasourceInitializationCondition.class})
    JdbcSessionDataSourceScriptDatabaseInitializer jdbcSessionDataSourceScriptDatabaseInitializer(@SpringSessionDataSource ObjectProvider<DataSource> sessionDataSource, ObjectProvider<DataSource> dataSource, JdbcSessionProperties properties) {
        DataSource dataSourceToInitialize = sessionDataSource.getIfAvailable(dataSource::getObject);
        return new JdbcSessionDataSourceScriptDatabaseInitializer(dataSourceToInitialize, properties);
    }

    @Bean
    @Order(value=-2147483648)
    SessionRepositoryCustomizer<JdbcIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, JdbcSessionProperties jdbcSessionProperties, ServerProperties serverProperties) {
        return sessionRepository -> {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
            map.from(jdbcSessionProperties::getTableName).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setTableName(arg_0));
            map.from(jdbcSessionProperties::getFlushMode).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setFlushMode(arg_0));
            map.from(jdbcSessionProperties::getSaveMode).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
            map.from(jdbcSessionProperties::getCleanupCron).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setCleanupCron(arg_0));
        };
    }

    static class OnJdbcSessionDatasourceInitializationCondition
    extends OnDatabaseInitializationCondition {
        OnJdbcSessionDatasourceInitializationCondition() {
            super("Jdbc Session", "spring.session.jdbc.initialize-schema");
        }
    }
}

