/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import reactor.netty.Metrics;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.netty.observability.ReactorNettyHandlerContext;
import reactor.netty.transport.AddressResolverGroupMetrics;
import reactor.netty.transport.HostnameResolutionObservations;
import reactor.util.context.ContextView;

final class MicrometerAddressResolverGroupMetrics<T extends SocketAddress>
extends AddressResolverGroupMetrics<T> {
    static final ConcurrentMap<Integer, MicrometerAddressResolverGroupMetrics<?>> cache = new ConcurrentHashMap();

    static MicrometerAddressResolverGroupMetrics<?> getOrCreate(AddressResolverGroup<?> resolverGroup, MicrometerChannelMetricsRecorder recorder) {
        return MapUtils.computeIfAbsent(cache, Objects.hash(resolverGroup, recorder), key -> new MicrometerAddressResolverGroupMetrics(resolverGroup, recorder));
    }

    MicrometerAddressResolverGroupMetrics(AddressResolverGroup<T> resolverGroup, MicrometerChannelMetricsRecorder recorder) {
        super(resolverGroup, recorder);
    }

    @Override
    protected AddressResolver<T> newResolver(EventExecutor executor) {
        return new MicrometerDelegatingAddressResolver((MicrometerChannelMetricsRecorder)this.recorder, this.resolverGroup.getResolver(executor));
    }

    static final class MicrometerDelegatingAddressResolver<T extends SocketAddress>
    extends AddressResolverGroupMetrics.DelegatingAddressResolver<T> {
        final String name;

        MicrometerDelegatingAddressResolver(MicrometerChannelMetricsRecorder recorder, AddressResolver<T> resolver) {
            super(recorder, resolver);
            this.name = recorder.name();
        }

        Future<List<T>> resolveAll(SocketAddress address, ContextView contextView) {
            return this.resolveAllInternal(address, () -> this.resolver.resolveAll(address), contextView);
        }

        Future<List<T>> resolveAllInternal(SocketAddress address, Supplier<Future<List<T>>> resolver, ContextView contextView) {
            FutureHandlerContext handlerContext = new FutureHandlerContext((MicrometerChannelMetricsRecorder)this.recorder, address);
            Observation sample = Observation.createNotStarted(this.name + ".address.resolver", handlerContext, Metrics.OBSERVATION_REGISTRY);
            if (contextView.hasKey("micrometer.observation")) {
                sample.parentObservation((Observation)contextView.get("micrometer.observation"));
            }
            sample.start();
            return resolver.get().addListener(future -> {
                handlerContext.status = future.isSuccess() ? "SUCCESS" : "ERROR";
                sample.stop();
            });
        }

        @Override
        Future<T> resolveInternal(SocketAddress address, Supplier<Future<T>> resolver) {
            FutureHandlerContext handlerContext = new FutureHandlerContext((MicrometerChannelMetricsRecorder)this.recorder, address);
            Observation observation = Observation.start(this.name + ".address.resolver", handlerContext, Metrics.OBSERVATION_REGISTRY);
            return resolver.get().addListener(future -> {
                handlerContext.status = future.isSuccess() ? "SUCCESS" : "ERROR";
                observation.stop();
            });
        }
    }

    static final class FutureHandlerContext
    extends Observation.Context
    implements ReactorNettyHandlerContext,
    Supplier<Observation.Context> {
        static final String CONTEXTUAL_NAME = "hostname resolution";
        static final String TYPE = "client";
        final String netPeerName;
        final String netPeerPort;
        final MicrometerChannelMetricsRecorder recorder;
        String status = "UNKNOWN";

        FutureHandlerContext(MicrometerChannelMetricsRecorder recorder, SocketAddress remoteAddress) {
            this.recorder = recorder;
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        @Override
        public Timer getTimer() {
            return this.recorder.getResolveAddressTimer(this.getName(), this.netPeerName + ':' + this.netPeerPort, this.status);
        }

        @Override
        public String getContextualName() {
            return CONTEXTUAL_NAME;
        }

        @Override
        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of(HostnameResolutionObservations.HostnameResolutionTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, HostnameResolutionObservations.HostnameResolutionTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort, HostnameResolutionObservations.HostnameResolutionTimeHighCardinalityTags.REACTOR_NETTY_PROTOCOL.asString(), this.recorder.protocol(), HostnameResolutionObservations.HostnameResolutionTimeHighCardinalityTags.REACTOR_NETTY_STATUS.asString(), this.status, HostnameResolutionObservations.HostnameResolutionTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE);
        }

        @Override
        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of(HostnameResolutionObservations.HostnameResolutionTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ':' + this.netPeerPort, HostnameResolutionObservations.HostnameResolutionTimeLowCardinalityTags.STATUS.asString(), this.status);
        }
    }
}

