/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.rule;

import java.util.Objects;
import org.apache.shenyu.common.enums.AiModelProviderEnum;

public class AiProxyHandle {
    private String provider;
    private String baseUrl;
    private String apiKey;
    private String model;
    private Double temperature = 0.8;
    private Integer maxTokens;
    private Boolean stream = false;

    public static AiProxyHandle newDefaultInstance() {
        AiProxyHandle aiProxyHandle = new AiProxyHandle();
        aiProxyHandle.setProvider(AiModelProviderEnum.OPEN_AI.getName());
        aiProxyHandle.setBaseUrl("https://api.openai.com");
        aiProxyHandle.setApiKey("your-api-key");
        aiProxyHandle.setModel("gpt-4o-mini");
        aiProxyHandle.setTemperature(0.8);
        aiProxyHandle.setStream(false);
        return aiProxyHandle;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        AiProxyHandle that = (AiProxyHandle)o;
        return Objects.equals(this.provider, that.provider) && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.model, that.model) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.stream, that.stream);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.baseUrl, this.apiKey, this.model, this.temperature, this.maxTokens, this.stream);
    }

    public String toString() {
        return "AiProxyHandle{provider='" + this.provider + "', baseUrl='" + this.baseUrl + "', apiKey='" + this.apiKey + "', model='" + this.model + "', temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", stream=" + this.stream + "}";
    }
}

