/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sdk.feign;

import java.util.Objects;
import org.apache.shenyu.common.utils.VersionUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.core.ShenyuInstanceRegisterRepositoryFactory;
import org.apache.shenyu.sdk.feign.ShenyuDiscoveryClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"shenyu.sdk.enabled"}, havingValue="true", matchIfMissing=true)
public class ShenyuSdkAutoConfiguration {
    @Bean
    public ShenyuInstanceRegisterRepository shenyuInstanceRegisterRepository(RegisterConfig config) {
        String registerType = config.getRegisterType();
        if ("local".equals(registerType)) {
            return null;
        }
        return ShenyuInstanceRegisterRepositoryFactory.newAndInitInstance((RegisterConfig)config);
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sdk")
    public RegisterConfig shenyuConfig() {
        return new RegisterConfig();
    }

    @Bean
    public ShenyuDiscoveryClient shenyuDiscoveryClient(ObjectProvider<ShenyuInstanceRegisterRepository> registerRepository, RegisterConfig registerConfig) {
        if (Objects.isNull(registerRepository.getIfAvailable())) {
            return new ShenyuDiscoveryClient(registerConfig);
        }
        return new ShenyuDiscoveryClient((ShenyuInstanceRegisterRepository)registerRepository.getIfAvailable(), registerConfig);
    }

    static {
        VersionUtils.checkDuplicate(ShenyuSdkAutoConfiguration.class);
    }
}

