/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.registry;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.core.ShenyuInstanceRegisterRepositoryFactory;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;

public class RegistryListener
implements ApplicationListener<WebServerInitializedEvent> {
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final String host;
    private final String appName;
    private final Properties props;
    private final ShenyuInstanceRegisterRepository repository;

    public RegistryListener(RegisterConfig config) {
        String registerType = config.getRegisterType();
        String serverLists = config.getServerLists();
        if (StringUtils.isBlank((CharSequence)registerType) || StringUtils.isBlank((CharSequence)serverLists)) {
            throw new ShenyuException("please config the registerType and serverList");
        }
        this.repository = ShenyuInstanceRegisterRepositoryFactory.newAndInitInstance((RegisterConfig)config);
        this.props = config.getProps();
        String name = this.props.getProperty("name");
        this.appName = StringUtils.isBlank((CharSequence)name) ? "shenyu-gateway" : name;
        String host = this.props.getProperty("host");
        this.host = StringUtils.isBlank((CharSequence)host) ? IpUtils.getHost() : host;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        String configPort = this.props.getProperty("port");
        int port = StringUtils.isBlank((CharSequence)configPort) ? event.getWebServer().getPort() : Integer.parseInt(configPort);
        InstanceEntity instanceEntity = this.buildInstanceRegisterDTO(port);
        this.repository.persistInstance(instanceEntity);
    }

    private InstanceEntity buildInstanceRegisterDTO(int port) {
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        return InstanceEntity.builder().appName(this.appName).host(host).port(Integer.valueOf(port)).build();
    }
}

