/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.springcloud;

import com.netflix.loadbalancer.IRule;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.springcloud.SpringCloudPlugin;
import org.apache.shenyu.plugin.springcloud.context.SpringCloudShenyuContextDecorator;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceRule;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonClientSpecification;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringCloudPluginConfiguration {
    @Bean
    public ShenyuPlugin springCloudPlugin(ObjectProvider<LoadBalancerClient> loadBalancerClient) {
        return new SpringCloudPlugin((LoadBalancerClient)loadBalancerClient.getIfAvailable());
    }

    @Bean
    public ShenyuContextDecorator springCloudShenyuContextDecorator() {
        return new SpringCloudShenyuContextDecorator();
    }

    @Bean
    public PluginDataHandler springCloudPluginDataHandler() {
        return new SpringCloudPluginDataHandler();
    }

    @Bean
    public RibbonClientSpecification ribbonClientSpecification() {
        Class[] classes = new Class[]{SpringCloudClientConfiguration.class};
        return new RibbonClientSpecification(String.join((CharSequence)".", "DEFAULT".toLowerCase(), RibbonClientSpecification.class.getName()), classes);
    }

    static class SpringCloudClientConfiguration {
        SpringCloudClientConfiguration() {
        }

        @Bean
        public IRule ribbonRule() {
            return new LoadBalanceRule();
        }
    }
}

