/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.k8s;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.DefaultControllerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.config.NettyHttpProperties;
import org.apache.shenyu.common.config.ssl.ShenyuSniAsyncMapping;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.k8s.parser.IngressParser;
import org.apache.shenyu.k8s.reconciler.EndpointsReconciler;
import org.apache.shenyu.k8s.reconciler.IngressReconciler;
import org.apache.shenyu.k8s.repository.ShenyuCacheRepository;
import org.apache.shenyu.plugin.base.cache.CommonDiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.plugin.base.cache.CommonPluginDataSubscriber;
import org.apache.shenyu.plugin.global.subsciber.MetaDataCacheSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.tcp.TcpSslContextSpec;

@Configuration
public class IngressControllerConfiguration {
    @Bean(value={"controller-manager"})
    public ControllerManager controllerManager(SharedInformerFactory sharedInformerFactory, @Qualifier(value="ingress-controller") Controller ingressController, @Qualifier(value="endpoints-controller") Controller endpointsController) {
        ControllerManager controllerManager = new ControllerManager(sharedInformerFactory, new Controller[]{ingressController, endpointsController});
        Executors.newSingleThreadExecutor().submit((Runnable)controllerManager);
        return controllerManager;
    }

    @Bean(value={"ingress-controller"})
    public Controller ingressController(SharedInformerFactory sharedInformerFactory, IngressReconciler ingressReconciler) {
        DefaultControllerBuilder builder = ControllerBuilder.defaultBuilder((SharedInformerFactory)sharedInformerFactory);
        builder = builder.watch(q -> ControllerBuilder.controllerWatchBuilder(V1Ingress.class, (WorkQueue)q).withResyncPeriod(Duration.ofMinutes(1L)).build());
        builder.withWorkerCount(2);
        return builder.withReconciler((Reconciler)ingressReconciler).withName("ingressController").build();
    }

    @Bean
    public IngressReconciler ingressReconciler(SharedIndexInformer<V1Ingress> ingressInformer, SharedIndexInformer<V1Secret> secretInformer, ShenyuCacheRepository shenyuCacheRepository, ObjectProvider<ShenyuSniAsyncMapping> shenyuSniAsyncMappingProvider, IngressParser ingressParser, ApiClient apiClient) {
        ShenyuSniAsyncMapping shenyuSniAsyncMapping = Optional.ofNullable((ShenyuSniAsyncMapping)shenyuSniAsyncMappingProvider.getIfAvailable()).orElse(new ShenyuSniAsyncMapping());
        return new IngressReconciler(ingressInformer, secretInformer, shenyuCacheRepository, shenyuSniAsyncMapping, ingressParser, apiClient);
    }

    @Bean(value={"endpoints-controller"})
    public Controller endpointsController(SharedInformerFactory sharedInformerFactory, EndpointsReconciler endpointsReconciler) {
        DefaultControllerBuilder builder = ControllerBuilder.defaultBuilder((SharedInformerFactory)sharedInformerFactory);
        builder = builder.watch(q -> ControllerBuilder.controllerWatchBuilder(V1Endpoints.class, (WorkQueue)q).withResyncPeriod(Duration.ofMinutes(1L)).build());
        builder.withWorkerCount(2);
        return builder.withReconciler((Reconciler)endpointsReconciler).withName("ingressController").build();
    }

    @Bean
    public EndpointsReconciler endpointsReconciler(SharedIndexInformer<V1Ingress> ingressInformer, SharedIndexInformer<V1Endpoints> endpointsInformer, ShenyuCacheRepository shenyuCacheRepository, ApiClient apiClient) {
        return new EndpointsReconciler(ingressInformer, endpointsInformer, shenyuCacheRepository, apiClient);
    }

    @Bean
    public ShenyuCacheRepository shenyuCacheRepository(CommonPluginDataSubscriber pluginDataSubscriber, CommonDiscoveryUpstreamDataSubscriber discoveryUpstreamDataSubscriber, MetaDataCacheSubscriber metaDataSubscriber, MetaDataCacheSubscriber metaDataCacheSubscriber) {
        return new ShenyuCacheRepository(pluginDataSubscriber, discoveryUpstreamDataSubscriber, (MetaDataSubscriber)metaDataSubscriber, metaDataCacheSubscriber);
    }

    @Bean
    public IngressParser ingressParser(SharedIndexInformer<V1Service> serviceInformer, SharedIndexInformer<V1Endpoints> endpointsInformer) {
        return new IngressParser(serviceInformer, endpointsInformer);
    }

    @Bean
    public SharedIndexInformer<V1Service> serviceInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
        GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Service.class, V1ServiceList.class, "", "v1", "services", apiClient);
        return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Service.class, 0L);
    }

    @Bean
    public SharedIndexInformer<V1Endpoints> endpointsInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
        GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Endpoints.class, V1EndpointsList.class, "", "v1", "endpoints", apiClient);
        return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Endpoints.class, 0L);
    }

    @Bean
    public SharedIndexInformer<V1Secret> secretInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
        GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Secret.class, V1SecretList.class, "", "v1", "secrets", apiClient);
        return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Secret.class, 0L);
    }

    @Bean
    public SharedIndexInformer<V1Ingress> ingressInformer(ApiClient apiClient, SharedInformerFactory sharedInformerFactory) {
        GenericKubernetesApi genericApi = new GenericKubernetesApi(V1Ingress.class, V1IngressList.class, "networking.k8s.io", "v1", "ingresses", apiClient);
        return sharedInformerFactory.sharedIndexInformerFor(genericApi, V1Ingress.class, 0L);
    }

    @Bean
    @ConditionalOnProperty(value={"shenyu.netty.http.web-server-factory-enabled", "shenyu.netty.http.sni.enabled"}, havingValue="true")
    public TcpSslContextSpec tcpSslContextSpec(ObjectProvider<NettyHttpProperties> properties, ApiClient apiClient) throws ApiException {
        NettyHttpProperties nettyHttpProperties = Optional.ofNullable((NettyHttpProperties)properties.getIfAvailable()).orElse(new NettyHttpProperties());
        NettyHttpProperties.SniProperties sniProperties = nettyHttpProperties.getSni();
        if (Objects.nonNull(sniProperties) && sniProperties.getEnabled().booleanValue() && "k8s".equals(sniProperties.getMod())) {
            String defaultNamespace;
            CoreV1Api coreV1Api = new CoreV1Api(apiClient);
            String defaultName = Optional.ofNullable(sniProperties.getDefaultK8sSecretName()).orElse("default-ingress-crt");
            V1Secret secret = coreV1Api.readNamespacedSecret(defaultName, defaultNamespace = Optional.ofNullable(sniProperties.getDefaultK8sSecretNamespace()).orElse("default"), "true");
            Map secretData = secret.getData();
            if (MapUtils.isEmpty((Map)secretData)) {
                ByteArrayInputStream crtStream = new ByteArrayInputStream((byte[])secretData.get("tls.crt"));
                ByteArrayInputStream keyStream = new ByteArrayInputStream((byte[])secretData.get("tls.key"));
                return TcpSslContextSpec.forServer((InputStream)crtStream, (InputStream)keyStream);
            }
            throw new ShenyuException(String.format("Can not read cert and key from default secret %s/%s", defaultNamespace, defaultName));
        }
        return TcpSslContextSpec.forServer((InputStream)new ByteArrayInputStream(new byte[0]), (InputStream)new ByteArrayInputStream(new byte[0]));
    }
}

