/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.annotation;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.core.util.Util;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public class RequestParamParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestParam> ANNOTATION = RequestParam.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(ShenyuRequest shenyuRequest, Annotation annotation, Object arg) {
        RequestTemplate requestTemplate = shenyuRequest.getRequestTemplate();
        RequestParam requestParam = ANNOTATION.cast(annotation);
        String name = requestParam.value();
        Util.checkState((StringUtils.isNotBlank((CharSequence)name) || arg instanceof Map ? 1 : 0) != 0, (String)"RequestParam.value() was empty on parameter %s#%s", (Object[])new Object[]{requestTemplate.getMethod().getDeclaringClass().getSimpleName(), requestTemplate.getMethod().getName()});
        StringBuilder pathResult = new StringBuilder(requestTemplate.getPath());
        Map params = Maps.newHashMap();
        if (!(arg instanceof Map) && !(arg instanceof MultipartFile)) {
            params.put(name, arg);
        } else if (arg instanceof Map) {
            params = (Map)arg;
        }
        params.forEach((key, value) -> {
            if (pathResult.indexOf("?") > 0) {
                pathResult.append("&");
            } else {
                pathResult.append("?");
            }
            pathResult.append(key).append("=").append(value);
        });
        shenyuRequest.setUrl(requestTemplate.getUrl() + pathResult);
        return true;
    }
}

