/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.core.util.Util;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.PathVariable;

public class PathVariableParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<PathVariable> ANNOTATION = PathVariable.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(ShenyuRequest shenyuRequest, Annotation annotation, Object arg) {
        String name = ANNOTATION.cast(annotation).value();
        RequestTemplate requestTemplate = shenyuRequest.getRequestTemplate();
        Util.checkState((arg instanceof String && StringUtils.isNotBlank((CharSequence)name) || arg instanceof Map ? 1 : 0) != 0, (String)"PathVariable Object class pls is String or Map<String, String> and PathVariable annotation value could not be empty when String class at the method %s.", (Object[])new Object[]{requestTemplate.getMethod()});
        if (arg instanceof String) {
            String varName = "{" + name + "}";
            String varNameRegex = "\\{" + name + "\\}";
            if (requestTemplate.getPath().contains(varName)) {
                shenyuRequest.setUrl(requestTemplate.getUrl() + RegExUtils.replaceAll((String)requestTemplate.getPath(), (String)varNameRegex, (String)String.valueOf(arg)));
            }
            return true;
        }
        String path = requestTemplate.getPath();
        for (Map.Entry entry : ((Map)arg).entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            String varName = "{" + key + "}";
            String varNameRegex = "\\{" + key + "\\}";
            if (!path.contains(varName)) continue;
            path = RegExUtils.replaceAll((String)path, (String)varNameRegex, (String)((String)value));
        }
        shenyuRequest.setUrl(requestTemplate.getUrl() + path);
        return true;
    }
}

